/**
 *    '$RCSfile: ResultPanel.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2006/01/30 15:27:22 $'
 *   '$Revision: 1.9 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.ecoinformatics.seek.ecogrid.quicksearch;

import java.awt.Color;

import javax.swing.JScrollPane;

import ptolemy.vergil.tree.EntityTreeModel;

/**
 * A display panel that is used to show the results of a query and allow
 * the user to drag and drop the items onto the canvas.
 *
 * @author Matt Jones
 */
class ResultPanel extends JScrollPane
{
    private DataSearchResultTree resultTree;


    /**
     * Construct a new ResultPanel.
     */
    public ResultPanel(EntityTreeModel resultTreeModel)
    {
        super();
        this.getViewport().setBackground(Color.WHITE);
        resultTree = new DataSearchResultTree(resultTreeModel, this);
        resultTree.setRootVisible(false);
        this.getViewport().add(resultTree);
    }

    /**
     * To update the treeModel in the resultpanel
     * @param newModel EntityTreeModel
     */
    public void setTreeModel(EntityTreeModel newModel)
    {
       resultTree.setModel(newModel);
       //resultTree.setRootVisible(false);
       //this.getViewport().add(resultTree);
       //resultTree.validate();
    }
    
  
}
