/**
 *    '$RCSfile: SortableResultRecord.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2006/01/30 17:01:15 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid.quicksearch;

import java.util.Vector;

/**
 * This object is one record in resultset from metacat ecogrid.
 * It has title, id and entityname vector
 * @author Jing Tao
 */

public class SortableResultRecord
{
  private String title      = null;
  private String id         = null;
  private Vector entityList = null;

  /**
   * Default construct
   * @param title String
   * @param id String
   * @param list Vector
   */
  public SortableResultRecord(String title, String id, Vector list )
  {
    this.title = title;
    this.id    = id;
    entityList = list;
  }

  /**
   * Method to get title
   * @return String
   */
  public String getTitle()
  {
    return this.title;
  }

  /**
   * Method to get id
   * @return String
   */
  public String getId()
  {
    return this.id;
  }

  /**
   * Method to get entity list vector
   * @return Vector
   */
  public Vector getEntityList()
  {
    return this.entityList;
  }
}
