/**
 *    '$RCSfile: TypeObject.java,v $'
 *
 *     '$Author: jones $'
 *       '$Date: 2003/12/18 08:35:26 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.workflow;

import ptolemy.data.type.Type;
import ptolemy.data.type.BaseType;

/**
 * a class to define a type
 */
public class TypeObject
{
  private String type;
  private String typeDim;

  /**
   * constructor that builds a TypeObject from an existing Type
   */
  public TypeObject(Type t)
  {
    typeDim = Types.SCALAR;

    if(t == BaseType.BOOLEAN)
    {
      type = Types.BOOLEAN;
    }
    else if(t == BaseType.BOOLEAN_MATRIX)
    {
      type = Types.BOOLEAN;
      typeDim = Types.MATRIX;
    }
    else if(t == BaseType.COMPLEX)
    {
      type = Types.COMPLEX;
    }
    else if(t == BaseType.COMPLEX_MATRIX)
    {
      type = Types.COMPLEX;
      typeDim = Types.MATRIX;
    }
    else if(t == BaseType.DOUBLE)
    {
      type = Types.DOUBLE;
    }
    else if(t == BaseType.DOUBLE_MATRIX)
    {
      type = Types.DOUBLE;
      typeDim = Types.MATRIX;
    }
    else if(t == BaseType.INT)
    {
      type = Types.INT;
    }
    else if(t == BaseType.INT_MATRIX)
    {
      type = Types.INT;
      typeDim = Types.MATRIX;
    }
    else if(t == BaseType.LONG)
    {
      type = Types.LONG;
    }
    else if(t == BaseType.LONG_MATRIX)
    {
      type = Types.LONG;
      typeDim = Types.MATRIX;
    }
    else if(t == BaseType.STRING)
    {
      type = Types.STRING;
    }
    else if(t == BaseType.OBJECT)
    {
      type = Types.OBJECT;
    }
    /*else if(t == BaseType.RECORD)
    {
      type = Types.RECORD;
    }*/
    else if(t == BaseType.UNSIGNED_BYTE)
    {
      type = Types.UNSIGNEDBYTE;
    }
    else if(t == BaseType.NUMERICAL)
    {
      type = Types.NUMERICAL;
    }
    else if(t == BaseType.GENERAL)
    {
      type = Types.GENERAL;
    }
  }

  /**
   * Constructor
   * @throws Exception if typeDimension is MATRIX and type is one of the
   * following: General, Numerical, Object, String, Unsigned_byte, Record
   * These types do not have matrix equivalents
   */
  public TypeObject(String type, String typeDimension) throws Exception
  {
    if(typeDimension.equals(Types.MATRIX))
    { //Only these types have a matrix dimension
      if(!type.equals(Types.BOOLEAN) &&
         !type.equals(Types.COMPLEX) &&
         !type.equals(Types.DOUBLE) &&
         !type.equals(Types.INT) &&
         !type.equals(Types.LONG))
      {
        throw new Exception("The type " + type + " does not have a matrix " +
          "form. Please choose one of the following types if you want to " +
          "use a matrix: Boolean, Complex, Double, Int, Long.");
      }
    }
    this.type = type;
    this.typeDim = typeDimension;
  }

  /**
   * create the type declaration for a TypedIOPort like this:
   * BaseType.STRING
   */
  public String getTypeDeclaration()
  {
    String baseString = "BaseType.";
    String matString = "";

    if(typeDim.equals(Types.MATRIX))
    {
      //We can only accept boolean, complex, double, int and long here
      //an exception is thrown from the constructor if the wrong type is
      //used for matrix, so we don't have to worry about it here.
      matString = "_MATRIX";
    }

    return baseString + type.toUpperCase() + matString;
  }

  ////////////////////////Accessors//////////////////////////
  public String getType()
  {
    return type;
  }

  public String getTypeDimension()
  {
    return typeDim;
  }
}
