/**
 * For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.authentication;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.utils.Options;

import javax.xml.rpc.ParameterMode;

/**
 * AuthenticationService is responsible for contact the GAMA service and get back the credential for the user
 * @author Zhijie Guan
 * guan@sdsc.edu
 *
 */

public class AuthenticationService {
	private String serviceURL;			// The GAMA web service URL
	private String operationName;		// The GAMA web service operation name
	private String userName;			// The user's name
	private String password;			// The user's password
	private String credential;			// The user's credential retrieved from the GAMA server
	
	/**
	 * @param operationName The operationName to set.
	 */
	protected void setOperationName(String operationName) {
		this.operationName = operationName;
	}
	
	/**
	 * @param password The password to set.
	 */
	protected void setPassword(String password) {
		this.password = password;
	}
	
	/**
	 * @param serviceURL The serviceURL to set.
	 */
	protected void setServiceURL(String serviceURL) {
		this.serviceURL = serviceURL;
	}
	
	/**
	 * @param userName The userName to set.
	 */
	protected void setUserName(String userName) {
		this.userName = userName;
	}
	
	/**
	 * Function: to check if the user can get authentication correctly. 
	 * Note: need to talk with GAMA group to see what will be returned if something is wrong
	 * @return True/False to state if the user get authenticated or not
	 */
	protected boolean isAuthenticated() {
		authenticate();						// Try to get authentication
		if (credential == null) {
			return false;
		}
		return true;
	}
	
	/**
	 * @return Credential to the user
	 */
	protected String getCredential() {
		return credential;
	}
	
	/**
	 * Use the GAMA authentication service to get credential
	 */
	private void authenticate() {
		try {
			Service  service = new Service();		// GAMA web service
			Call     call    = (Call) service.createCall();		// Service call
			
			call.setTargetEndpointAddress( new java.net.URL(serviceURL) );
			call.setOperationName(operationName);
			
			// call parameters
			call.addParameter( "username", XMLType.XSD_STRING, ParameterMode.IN );
			call.addParameter( "passwd", XMLType.XSD_STRING, ParameterMode.IN );
			call.setReturnType( XMLType.XSD_STRING );
			
			Object returnObject = call.invoke( new Object[] { userName , password } );
			if (returnObject == null) {
				credential = null;
			} else {
				credential = (String)returnObject;
			}
		} catch (Exception e) {
			System.err.println("Authentication Service error!" + e.toString());
		}
	}

}
