/**
 * For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.authentication;

/**
 * The DomainList is used to store all of the domain info included in Kepler authentication framework.
 * Currently we only have two domains: GEON and SEEK.
 * In the future, with more domains added into the authentication framework, all the domain info would
 * be stored in a XML configuration file. This class needs to parse that file and read the domain info 
 * into the system. 
 * @author Zhijie Guan
 * guan@sdsc.edu
 *
 */

public class DomainList {
	private Domain domains[] = new Domain[2];		// Domain list used to store the domain info
	
	/**
	 * The constructor is used to set/read domain info
	 *
	 */
	public DomainList () {
		domains[0] = new Domain();
		domains[0].setDomain("GEON");
		domains[0].setServiceOperation("loginUserMyProxy");
		domains[0].setServiceURL("http://geon09.sdsc.edu:9090/axis/services/SecurityMyproxyloginService");
		
		domains[1] = new Domain();
		domains[1].setDomain("SEEK");
		domains[1].setServiceOperation("loginUserMyProxy");
		domains[1].setServiceURL("http://geon09.sdsc.edu:9090/axis/services/SecurityMyproxyloginService");
	}
	
	/**
	 * @return Domain list
	 */
	public Domain[] getDomainList() {
		return domains;
	}

}
