/**
 *  '$RCSfile: ResultHighlighter.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: ruland $'
 *     '$Date: 2005/11/01 20:39:10 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.kepler.gui;

import javax.swing.tree.TreePath;

import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.tree.PTree;


/**
 * This class implements a simple result display where the results from the
 * search are simply highlighted in the tree.  Any subtree where a result
 * may be located is also expanded.
 *
 * @author Chad Berkley
 */
public class ResultHighlighter extends LibrarySearchResultPane
{
  /**
   * the constructor passes in the library to highlight the results in
   * and the results to highlight.  if results is null, the tree is built
   * fully collapsed with no highlights.
   * @param library the library to highlight the results in
   * @param results the results to highlight
   */
  public ResultHighlighter(PTree library, LibrarySearchResults results)
    throws IllegalActionException
  {
    super(library, results);
  }

  /**
   * this method allows the search results to be updated in the panel
   * @param results the results to update to
   */
  public void update(LibrarySearchResults results)
  {
    this.results = results;
    if(results != null)
    {
      TreePath[] tp = createTreePathArray();
      library.clearSelection(); //clear the current selections
      collapseAll();
      for(int i=0; i<tp.length; i++)
      {
        //library.expandPath(tp[i]);
        library.addSelectionPath(tp[i]);
      }
    }
  }

  /**
   * A factory that creates the searcher to search the library
   */
  public static class Factory extends LibrarySearchResultPaneFactory
  {
    /** Create an factory with the given name and container.
     *  @param container The container.
     *  @param name The name of the entity.
     *  @exception IllegalActionException If the container is incompatible
     *   with this attribute.
     *  @exception NameDuplicationException If the name coincides with
     *   an attribute already in the container.
     */
    public Factory(NamedObj container, String name)
            throws IllegalActionException, NameDuplicationException
    {
      super(container, name);
    }

    /**
     *  creates a ResultsHighlighter and returns it.
     *  @param _libraryModel the model containing the actor library
     *  @return A new LibraryPane that displays the library
     */
    public LibrarySearchResultPane createLibrarySearchResultPane(PTree library,
      LibrarySearchResults results) throws IllegalActionException
    {
      return new ResultHighlighter(library, results);
    }
  }
}
