/**
 *  '$RCSfile: SimpleSearchUIPane.java,v $'
 *  '$Author: brooke $'
 *  '$Date: 2006/02/13 19:48:46 $'
 *  '$Revision: 1.4 $'
 *
 *  For Details:
 *  http://kepler.ecoinformatics.org Copyright (c) 2004 The Regents of the
 *  University of California. All rights reserved. Permission is hereby granted,
 *  without written agreement and without license or royalty fees, to use, copy,
 *  modify, and distribute this software and its documentation for any purpose,
 *  provided that the above copyright notice and the following two paragraphs
 *  appear in all copies of this software. IN NO EVENT SHALL THE UNIVERSITY OF
 *  CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
 *  OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
 *  DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY
 *  DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 *  SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.gui;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;

import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;


/**
 *  Class to build the search gui pane that allows the user to enter a single
 *  search term to search by.
 *
 *@author     berkley
 *@created    February 17, 2005
 */
public class SimpleSearchUIPane extends LibrarySearchPane {

  //constants
  private final String QUICKSEARCHLABEL = "Search";

  private SearchUIJPanel searchUIJPanel;

  /**
   *  constructor
   *
   *@param  searchButtonHandler  Description of the Parameter
   */
  public SimpleSearchUIPane(ActionListener searchButtonHandler) {
    super(searchButtonHandler);
    init();
  }


  /**
   *@return     The searchTerm value
   *@returns    the search term
   */
  public String getSearchTerm() {
    return searchUIJPanel.getSearchTerm();
  }


  /*
   *  Initialize the search panel
   */
  private void init() {

    this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

    searchUIJPanel =  new SearchUIJPanel(
        //title for search box
        QUICKSEARCHLABEL,
        // Search Action
        new AbstractAction() {
          public void actionPerformed(ActionEvent e) {
            searchButtonHandler.actionPerformed(e);
          }
        },
        // Reset Action
        new AbstractAction() {
          public void actionPerformed(ActionEvent e) {
            searchUIJPanel.setSearchTerm("");
            searchButtonHandler.actionPerformed(e);
          }
        },
        // pass null for now, so remainder of
        // buttons don't get rendered yet
        null, null, null

//        // Cancel Action
//        new AbstractAction() {
//          public void actionPerformed(ActionEvent e) {
//            //code to cancel search
//          }
//        },
//        // Sources Action
//        new AbstractAction() {
//          public void actionPerformed(ActionEvent e) {
//            //code to pop up sources dialog
//          }
//        },
//        // Advanced Search Action
//        new AbstractAction() {
//          public void actionPerformed(ActionEvent e) {
//            //code to pop up advanced search dialog
//          }
//        }
      );

    this.add(searchUIJPanel);
  }



  /**
   * get the preferred/minimum width of this panel - calculated to allow enough
   * space for all buttons and spacers etc
   *
   * @return the minimum allowable width of this panel
   */
  public final int getMinimumWidth() {
    return searchUIJPanel.getMinimumWidth();
  }


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  /**
   *  A factory that creates the searcher gui to search the library
   *
   *  @author     brooke
   *  @created    4 Nov 2005
   */
  public static class Factory extends LibrarySearchGUIPaneFactory {
    /**
     *  Create a factory with the given name and container.
     *
     *@param  container                     The container.
     *@param  name                          The name of the entity.
     *@exception  IllegalActionException    If the container is incompatible
     *      with this attribute.
     *@exception  NameDuplicationException  If the name coincides with an
     *      attribute already in the container.
     */
    public Factory(NamedObj container, String name) throws
      IllegalActionException, NameDuplicationException {
      super(container, name);
    }


    /**
     *  creates a ScrollBarModifier and returns it.
     *
     *@param  searchButtonHandler  the ActionListener to handle the search
     *      button events
     *@return                      A new LibrarySearchPane that displays the
     *      search pane
     */
    public LibrarySearchPane createLibrarySearchGUIPane(ActionListener
      searchButtonHandler) {
      return new SimpleSearchUIPane(searchButtonHandler);
    }
  }
}
