
package org.kepler.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import org.ecoinformatics.util.Config;

public class SplashScreen extends JFrame {
    Image   splashImage;

    SplashScreen( URL imagefile, int timeout ) {
        setUndecorated(true);
        setBackground(new Color(255,255,255));
        // start loading the image, asynchronously      
        splashImage = loadImage(imagefile);
        // resize frame to match size of image, and keep frame at centre of screen
        positionAtCenter(splashImage.getWidth(null), 
                                     splashImage.getHeight(null));

        if ( timeout > 0) {
            Timeout t = new Timeout(timeout);
        }
        
        addMouseListener( new MouseAdapter() {
    		public void mouseReleased(MouseEvent arg0) {
                dismiss();
    		}
        });

        setVisible(true);
    }

    /**
     *  Positions the window at the centre of the screen, taking into account
     *  the specified width and height
     */
    private void positionAtCenter(int width, int height){
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-width)/2,
                  (screenSize.height-height)/2,
                  width,
                  height);
    }

    public void dismiss() {
        if (!SwingUtilities.isEventDispatchThread() ) {
            SwingUtilities.invokeLater( new Runnable() {
                public void run() {
                    setVisible(false);
                    dispose();
                }
            });
        }
        else {
            setVisible(false);
            dispose();
        }
    }
    
    public void paint(Graphics g){
    	g.drawImage(splashImage,0,0,null);
    }

    public void update(Graphics g){
        paint(g);
    }

    class Timeout implements Runnable {
    	int t;
    	Thread timer;
    	public Timeout( int time ) {
    		t = time;
    		timer = new Thread(this);
    		timer.setDaemon(true);
    		timer.start();
    	}
    	public void run() {
    		try {
    			Thread.sleep(t);
    		}
    		catch( InterruptedException e ) {}
    		finally {
                dismiss();
    		}
    	}
    }

    Image loadImage(URL image ) {
        splashImage = Toolkit.getDefaultToolkit().createImage(image);
        
        // wait for image to be loaded
        MediaTracker tracker = new MediaTracker(SplashScreen.this);
        tracker.addImage(splashImage,0);
        try {
            tracker.waitForID(0);
        }
        catch(InterruptedException e){
            e.printStackTrace();
            System.exit(1);
        }
    	return splashImage;
    }
    
	public static final void main(String [] args) throws Exception {
        Config c = Config.getInstance();
		
        String splashname = c.getValue("//startup/splashimage");
        String splashto = c.getValue("//startup/splashtimeout");
        
        int splashtimeout = Integer.parseInt(splashto);

    	new SplashScreen(new java.io.File(splashname).toURL(),splashtimeout);

		Thread.sleep(600);
		System.out.println("I'm outta here");
	}
	
}

