/*
 *  Copyright (c) 2003-2004 The Regents of the University of California.
 *  All rights reserved.
 *  Permission is hereby granted, without written agreement and without
 *  license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies
 *  of this software.
 *  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 *  THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 *  PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 *  PT_COPYRIGHT_VERSION_2
 *  COPYRIGHTENDKEY
 */
package org.kepler.objectmanager;

import java.io.InputStream;

/**
 * This is an interface for class that resolve ids to various forms.
 *
 *@author     Chad Berkley
 *@created    April 07, 2005
 */
public interface IDResolverInterface
{
  /**
   * resolves the id and returns the stream of whatever it points to
   * @param id the id to resolve
   * @return InputStream
   * @throws IDNotFoundException if the id isn't found
   */
  public InputStream resolveID(String id) throws IDNotFoundException;

  /**
   * resolves an id to a (actor) class metadata
   * @param id the id to resolve
   * @return ActorMetadata metadata for the actor class
   * @throws IDNotFoundException if the id cannot be resolved to a class
   */
  public abstract ActorMetadata resolveIDToActor(String id)
    throws IDNotFoundException, InvalidMetadataException;

  /**
   * returns true if the passed id is resolvable by the implemented id resolver
   * @param id
   * @return boolean
   */
  public abstract boolean isResolvable(String id);
}
