/**
 *    '$RCSfile: DSTableFieldDef.java,v $'
 *
 *     '$Author: tao $'
 *       '$Date: 2006/03/11 01:17:02 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.objectmanager.data.db;

import java.util.Vector;

import org.kepler.objectmanager.data.DataObjectDescription;
/**
 * Simple Implementation of DSTableKeyIFace/DSTableFieldIFace interface
 * This class is derived from DataObjectDescription
 */
public class DSTableFieldDef extends DataObjectDescription implements DSTableKeyIFace
{
  protected int          mKeyType = DSTableKeyIFace.UNDEFINEDKEY;
  protected DSTableIFace mTable   = null;
  //private Vector mMissingValueCode = new Vector();
  
  
  /**
   * Construct a DSTableFieldDef.
   * @param aId the id of the field
   * @param aName the name of the field
   * @param aDataType the datatype of the field
   */
  public DSTableFieldDef(String aId, String aName, String aDataType, Vector aMissingValueCode)
  {
    super(aId, aName, aDataType, null);
    setMissingValueCode(aMissingValueCode);
  }
 
  /**
   * Construct a DSTableFieldDef.
   * @param aId the id of the field
   * @param aName the name of the field
   * @param aDataType the datatype of the field
   * @param aKeyType the datatype of the field
   */
  public DSTableFieldDef(String aId, String aName, String aDataType, int aKeyType,Vector aMissingValueCode)
  {
    super(aId, aName, aDataType, null);
    setMissingValueCode(aMissingValueCode);
    mKeyType = aKeyType;
    //mMissingValueCode = aMissingValueCode;
  }
  
  /**
   * Sets the Parent DSTableDef object
   * @param aTable DSTableDef object
   */
  public void setTable(DSTableIFace aTable)
  {
    mTable = aTable;
  }

  /**
   * Returns the table for the field
   * @return DSTableDef Object
   */
  public DSTableIFace getTable()
  {
    return mTable;
  }
  
  /**
   * @return Returns the mKeyType.
   */
  public int getKeyType()
  {
    return mKeyType;
  }
  
}
