/**
 *    '$RCSfile: DSTableKeyIFace.java,v $'
 *
 *     '$Author: zhu $'
 *       '$Date: 2005/07/06 02:50:43 $'
 *   '$Revision: 1.1 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.objectmanager.data.db;


/**
 * Inherits from DSTableFieldIFace and adds a method to determine the type of key it is.
 */
public interface DSTableKeyIFace extends DSTableFieldIFace
{
  /** Indicates a Undefined Key Type */
  public static final int UNDEFINEDKEY = 0;
  /** Indicates a Primary Key */
  public static final int PRIMARYKEY = 1;
  /** Indicates a Secondary Key */
  public static final int SECONDARYKEY = 2;
  
  /**
   * Return whether it is a Primary or Secondary Key
   * @return the type of key
   */
  public int getKeyType();
  
}
