/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/*-------------------------------------------------------------------------------
  Guilian Wang
  June 22, 2004

  File Name:      AbstractSchema.java
  Description:    This program is to define the interface AbstractSchema. It
                  includes all the necessary constructors to create a schema from
                  any input schema format (DTD, XML Schema, relational schema)
                  and operators for
                  manipulating types in a schema.
  -----------------------------------------------------------------------------*/
import java.util.List;
import java.util.Set;


public interface AbstractSchema {
    //constructor
    //AbstractSchema AbstractSchema(String schemaFile, String schemaType);
    // methods, by default, they are all public
    String getSchemaType();

    Type getTypeFromTag(String tag);

    Type getTopType();

    List listOf(Type elem); //polymorphic

    Set setOf(Type elem); //polymorphic

    TupleList product(List typeList); //polymorphic, ????

    String append(String str1, String str2);

    List cons(Type elem, List l); //polymorphic

    Type head(List l); //polymorphic

    List tail(List l);
}
