/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import com.manspace.resultSetDOMWrapper.ResultSetDocument;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;


/**
 * DBDOM is to wrap a ResultSet into a DOM, so XQuery or XSLT can work with
 * it. It is based on the resultset dom wrapper package.
 *
 * @author Guilian Wang
 */
public class DBDOM {
    public static void main(String[] args) {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();

            Connection conn = DriverManager.getConnection(
                    "jdbc:mysql://www.freesql.org:3306" +
                    "/fieldDB?user=jenny2004&password=jenny2004");
            Statement stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
                    ResultSet.CONCUR_READ_ONLY);

            String query = "SELECT * FROM StudyC";

            if (stmt.execute(query)) {
                ResultSet rs = stmt.getResultSet();
                Document doc = new ResultSetDocument(rs);

                if (doc == null) {
                    if (SCIA.debug_on) {
                        System.err.println("doc = null");
                    }
                }

                Element root = doc.getDocumentElement();

                if (SCIA.debug_on) {
                    System.err.println("root= " + root.getTagName());
                }

                NodeList nodeList = root.getChildNodes();

                for (int i = 0; i < nodeList.getLength(); i++) {
                    Node node = nodeList.item(i);
                    String tag = node.getLocalName();
                    NodeList cellNodes = node.getChildNodes();

                    for (int j = 0; j < cellNodes.getLength(); j++) {
                        Node cellNode = cellNodes.item(j);
                        String name = cellNode.getLocalName();

                        String value = cellNode.getNodeValue();

                        if (SCIA.debug_on) {
                            System.err.println("parent=" + tag + " localName=" +
                                name + " value=" + value);
                        }
                    }
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();

            if (SCIA.debug_on) {
                System.err.println("SQLState: " + e.getSQLState());
            }

            if (SCIA.debug_on) {
                System.err.println("VendorError: " + e.getErrorCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
