/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/************************************************
 * Prompts the user to enter text.  The public
 * attribute data allows accessing the user-entered
 * text by the caller method
 *
 * @author Vitaliy Zavesov
 ************************************************/
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JTextField;


public class Interactive1 extends JFrame {
    // global variables so that they could be set
    public String data;

    // global variables so that they could be set
    public String prompt;
    JTextField textField;

    // constructor
    public Interactive1(final String p) {
        setTitle(" ");

        // setting the global variable
        prompt = p;

        // position our popup window in the center of the screen
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();

        textField = new JTextField(40);

        KeyAdapter kl = new KeyAdapter() {
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
                        hide();
                        data = textField.getText();
                    }
                }
            };

        // setting up the panel with the text area
        Panel pan = new Panel();
        pan.add(textField);

        TextCanvas can = new TextCanvas(prompt);
        getContentPane().add(can, "Center");
        can.repaint();

        FontMetrics fm = getFontMetrics(can.f);
        int size = (fm.getHeight() + 6) * (can.cnt + 1);
        size += 75;

        setSize(500, size);
        setLocation(d.width - this.getWidth(), d.height - this.getHeight() -
            30);

        textField.addKeyListener(kl);
        getContentPane().add(pan, "South");
    }
}
