/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.util.List;
import java.util.Vector;


/**
 * The SCIA representation for a schema node's match in another schema.
 * It is a field of a schema tree
 * node
 * @see TNode.
 *
 * @author Guilian Wang
 */
public class Matching {
    public TNode tnode; // for local 1:1 match
    public String operations; // on the single source node
    public List matchingUnits; // for local 1:k match where k > 1
    public Condition condition;
    public String conditionStr; // condition in string format

    // for a node that has a grouping match, computes a grouping condition 
    // for its children as aggregation condition
    public String groupCondForChild;
    public double sim;
    public Vector groupAttrs; // grouping attributes

    //Ex. books from grouped by book to grouped by author
    public boolean crossLevelGrouping = false; 

    //Ex. author in target, for books from grouped by book to grouped by author
    public boolean isCrossLevelGroupAttr = false;
    public String aggregateOp; // aggregation operator
    

    public Matching(TNode n, double s) {
        tnode = n;
        sim = s;
    }

    public Matching(TNode n, double s, Vector grpAttrVec) {
        tnode = n;
        sim = s;
        groupAttrs = grpAttrVec;
    }

    public Matching(TNode n, double s, String aggreOp) {
        tnode = n;
        sim = s;
        aggregateOp = aggreOp;
    }

    public Matching(TNode n, double s, String op, Vector grpAttrVec,
        String aggreOp, Condition cond) {
        tnode = n;
        sim = s;
        operations = op;
        condition = cond;
        groupAttrs = grpAttrVec;
        aggregateOp = aggreOp;
    }

    public Matching() {
        tnode = null;
        sim = 0.0;
    }

    public Matching(List mUnits, double s) {
        matchingUnits = mUnits;
        sim = s;
    }
}
