/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;

import java.io.PrintWriter;
import java.util.List;


public class Type {
    public String typeName;
    public String typeType;
    public Cardinality occurs;
    public boolean isAttribute;
    public List components; // for tuple
    public Type element; // e.g. S(C_Book) = ListOf(Book)
    public String constraint;

    public Type() {
        typeName = null;
    }

    public Type(String name) {
        typeName = name;
    }

    public Type(String name, String tt) {
        typeName = name; //Author, Address, etc
        typeType = tt; //TupleList, List, String, Integer, etc
    }

    public Type(String name, String tt, List l) {
        typeName = name; //Author, Address, etc
        typeType = tt; //TupleList, List, String, Integer, etc

        //for tuple, e.g: for Author = first x last {(Type)first, (Type)last}
        components = l;
    }

    public Type(String name, boolean isAttr, String tt) {
        typeName = name; //Author, Address, etc
        typeType = tt; //TupleList, List, String, Integer, etc
        isAttribute = isAttr;
    }

    public Type(String name, boolean isAttr, String atomicType, String minOc,
        String maxOc) {
        typeName = name;
        isAttribute = isAttr;
        occurs = new Cardinality(minOc, maxOc);

        if ((minOc != null) || (maxOc != null)) {
            if ((minOc != null) && (maxOc != null)) {
                if (minOc.equals("1") && maxOc.equals("1")) {
                    typeType = atomicType;

                    return;
                }
            }

            //typeName = name.substring(0, 1).toUpperCase() + name.substring(1);
            typeName = "C_" + name; // for collection types: list, set
            typeType = "List";
            element = new Type(name, isAttr, atomicType);
            constraint = "|" + typeName + "|";

            if (minOc != null) {
                constraint = constraint + " >= " + minOc;
            }

            if ((maxOc != null) && !maxOc.equals("*") &&
                    !maxOc.equalsIgnoreCase("unbounded")) {
                constraint = maxOc + " >= " + constraint;
            }
        } else if ((minOc == null) && (maxOc == null)) {
            typeType = atomicType;
        }
    }

    public PrintWriter write(PrintWriter stream) { // write type

        if ((typeName != null) && (typeType != null)) {
            if ((components == null) && !typeType.equals("List")) {
                // for atomic types
                stream.println("S(" + typeName + ") = " + typeType);
            }

            if (typeType.equals("List")) {
                // for repeatable atomic types
                stream.print("S(" + typeName + ") = ListOf(" +
                    element.typeName + ")");
                stream.println("  " + constraint);
            }

            if ((components != null) && !components.isEmpty()) {
                // for complex types: product
                stream.print("S(" + typeName + ")= ");

                for (int i = 0; i < components.size(); i++) {
                    Type component = (Type) components.get(i);

                    if (component.typeName != null) {
                        if (i == (components.size() - 1)) {
                            stream.print(component.typeName);
                        } else {
                            stream.print(component.typeName + " x ");
                        }
                    }
                }

                stream.println();
            }
        }

        return stream;
    }

    public PrintWriter write_All(PrintWriter stream) {
        write(stream);

        if ((typeType != null) && typeType.equals("List") && (element != null)) {
            element.write_All(stream);
        }

        if ((components != null) && !components.isEmpty()) {
            for (int i = 0; i < components.size(); i++) {
                Type component = (Type) components.get(i);
                component.write_All(stream);
            }
        }

        return stream;
    }

    public Type getTypeFromTagForAll(String t) {
        Type type = getTypeFromTag(t);

        if (type == null) {
            if (typeType.equalsIgnoreCase("List")) {
                type = element.getTypeFromTagForAll(t);

                if (type != null) {
                    return type;
                }
            } else if ((components != null) && !components.isEmpty()) {
                //System.out.println("components != null");
                for (int i = 0; i < components.size(); i++) {
                    Type component = (Type) components.get(i);

                    if (component != null) {
                        type = component.getTypeFromTagForAll(t);

                        if (type != null) {
                            return type;
                        }
                    }
                }
            }
        }

        return type;
    }

    public Type getTypeFromTag(String t) {
        //System.out.println(this.typeName + ".getTypeFromTag(" + t + ")");
        if (typeName.equalsIgnoreCase(t)) {
            //System.out.println(" = " + this.typeName + " type: " + typeType);
            return this;
        }

        return null;
    }
}
