/**
 *    '$RCSfile: NamedOntProperty.java,v $'
 *
 *     '$Author: bowers $'
 *       '$Date: 2005/11/08 00:29:57 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.sms;

import com.hp.hpl.jena.ontology.*; 
import java.util.*;

/**
 * 
 */
public class NamedOntProperty implements Comparable { 

    private OntProperty _ontProperty;
    private String _name;


    public NamedOntProperty(OntProperty ontProperty) {
	_ontProperty = ontProperty;
	String str = ontProperty.getLabel(null);
	if(str != null)
	    _name = new String(str);
	else
	    _name = new String(ontProperty.getLocalName());
    }

    public String toString() {
	return getName();
    }


    /**
     * @return The domain of the property (a set of NamedOntClasses)
     */
    public Iterator getDomain(boolean sorted) {
	Vector result = new Vector();
	for(Iterator iter = _ontProperty.listDomain(); iter.hasNext();) {
	    OntResource res = (OntResource)iter.next();
	    NamedOntClass c = getOntClass(res);
	    if(c != null)
		result.add(c);
	}
	if(sorted)
	    Collections.sort(result);
	return result.iterator();
    }


    /**
     * FIXME: Need to support non class ranges
     */
    public Iterator getRange(boolean sorted) {
	Vector result = new Vector();
	for(Iterator iter = _ontProperty.listRange(); iter.hasNext();) {
	    OntResource res = (OntResource)iter.next();
	    NamedOntClass c = getOntClass(res);
	    if(c != null)
		result.add(c);
	}
	if(sorted)
	    Collections.sort(result);
	return result.iterator();
    }

    /**
     * Given a resource, returns its ontology class if it has one.
     * and null otherwise.
     */
    private NamedOntClass getOntClass(OntResource res) {
	String lname = res.getLocalName();
	String nspace = res.getNameSpace();
	OntologyCatalog catalog = OntologyCatalog.instance();
	return catalog.getNamedOntClass(nspace, lname);
    }



    public String getName() {
	return _name;
    } 


    /**
     */
    public Iterator getNamedSuperProperties(boolean sorted) {
	Vector result = new Vector();
	for(Iterator iter = _ontProperty.listSuperProperties(true); iter.hasNext();) {
	    OntProperty p = (OntProperty)iter.next();
	    if(p != null && !result.contains(p))
		result.add(new NamedOntProperty(p));
	}
	if(sorted)
	    Collections.sort(result);
	return result.iterator();
    }


    /**
     */
    public Iterator getNamedSubProperties(boolean sorted) {
	Vector result = new Vector();
	for(Iterator iter = _ontProperty.listSubProperties(true); iter.hasNext();) {
	    OntProperty p = (OntProperty)iter.next();
	    if(p != null && !result.contains(p))
		result.add(new NamedOntProperty(p));
	}
	if(sorted)
	    Collections.sort(result);
	return result.iterator();
    }



    public int compareTo(Object obj) {
	String str1 = toString();
	String str2 = obj.toString();
	return str1.compareTo(str2);
    }


    /**
     * @return The (first) comment associated with the property
     */
    public String getComment() {
	return _ontProperty.getComment(null);
    }

    protected OntProperty ontProperty() {
	return _ontProperty;
    }

    public boolean equals(Object obj) {
	if(!(obj instanceof NamedOntProperty))
	    return false;
	NamedOntProperty tmp = (NamedOntProperty)obj;
	if(!tmp.ontProperty().equals(this.ontProperty()))
	    return false;
	return true;
    }

} //NamedOntProperty

