/*
 * Griddles Remote File ........
 *
 * Copyright (c) 2000-2003 The Regents of the University of California. All
 * rights reserved. Permission is hereby granted, without written agreement and
 * without license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the above
 * copyright notice and the following two paragraphs appear in all copies of
 * this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN
 * "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * PT_COPYRIGHT_VERSION_2 COPYRIGHTENDKEY
 */
package org.monash.griddles;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;



//////////////////////////////////////////////////////////////////////////
////GriddlesRemoteFile
/************
  *  GriddlesRemoteFile represents a remote file with one GriddLeS input port 
  *  that holds name of the remote file with the complete path in a string parameter. 
  *  The GriddLeS runtime environment saves data when connected to another actor. 
  *  It also holds additional information as its state to store the location of remote 
  *  host and web service specific information in case the data transmission is taking 
  *  place by using web service client. The data is transmitted into this file either by 
  *  using the gridFtp client module or by using the GriddLeS web service mechanism depending 
  *  on the mode of data transfer.   
  * 
  *
  * @author Jagan Kommineni, Monash University July 2005
  * @version $Id: GriddlesRemoteFile.java,v 1.2 2005/11/01 20:39:13 ruland Exp $
  * @since 
  *************/
         public class GriddlesRemoteFile extends TypedAtomicActor {
	/**
	 * Construct a GriddlesRemoteFile actor with the given container and name.
	 *
	 * @param container
	 *            The container.
	 * @param name
	 *            The name of this actor.
	 * @exception IllegalActionException
	 *                If the actor cannot be contained by the proposed
	 *                container.
	 * @exception NameDuplicationException
	 *                If the container already has an actor with this name.
	 */
	public GriddlesRemoteFile(CompositeEntity container, String name)
			throws IllegalActionException, NameDuplicationException {
		super(container, name);
                
                remoteHostName = new Parameter(this, "remoteHostName", new StringToken("brecca-2.vpac.org"));
                webServicePort = new Parameter(this, "webServicePort", new StringToken("8080"));
                remoteHostName.setStringMode(true);
                webServicePort.setStringMode(true);      
		GriddlesRemoteFile = new TypedIOPort(this, "GriddlesRemoteFile", true, false);
		GriddlesRemoteFile.setTypeEquals(BaseType.STRING);

                modelReference = new Parameter(this,"modelReference",new StringToken("GriddlesRemoteFile"));
                modelReference.setStringMode(true);
                
                modelReference.setVisibility(modelReference.NOT_EDITABLE);
		filename = new Parameter(this, "filename", new StringToken("Enter file name with full path of remote file"));
		filename.setStringMode(true);
               
                
		_attachText("_iconDescription", "<svg>\n"
				+ "<rect x=\"-25\" y=\"-20\" " + "width=\"50\" height=\"40\" "
				+ "style=\"fill:white\"/>\n"
				+ "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
				+ " 15,-10 15,10, -15,10\" " + "style=\"fill:yellow\"/>\n"
				+ "</svg>\n");
	} // end of constructor
	///////////////////////////////////////////////////////////////////
	//// ports and parameters ////
	/**
	 * The local input & output file names
	 */
	public TypedIOPort GriddlesRemoteFile;
	public Parameter filename;
        public Parameter modelReference;
        public Parameter remoteHostName;
        public Parameter webServicePort;
          
	//No execution components attached to this actor, it is abstract representation of a remote file ...
	public void fire() throws IllegalActionException 
          {
           
	  } // end of fire
        public boolean postfire() 
          {
          return false;
          }
}