/* TODO One line description of class.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

 @ProposedRating Red (tmcphillips@naturaldiversity.org)
 @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp;

import java.util.List;

import org.nddp.CollectionHandler.TokenDisposition;
import org.nddp.CollectionIOPort.NondataHandler;
import org.nddp.exceptions.CollectionException;
import org.nddp.tokens.ExceptionToken;
import org.nddp.tokens.LoopTerminationToken;
import org.nddp.tokens.MetadataToken;

import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

////////////////////////////////////////////////////////////////////////// 
//// CollectionActor 

/** 
 @author Timothy M. McPhillips
 */

public interface Coactor extends Nameable {

    TokenDisposition defaultDataDisposition();
    
    CollectionIOPort _getDefaultOutputPort();
    
    void _handleCollectionEnd(CollectionManager collectionManager) 
        throws IllegalActionException, CollectionException;
    
    CollectionHandler.ExceptionDisposition handleCollectionException(CollectionManager
            collectionManager, CollectionException exception);
    
    CollectionHandler.CollectionDisposition _handleCollectionStart(CollectionManager 
            collectionManager) throws IllegalActionException, CollectionException; 
    
    CollectionHandler.TokenDisposition _handleData(CollectionManager collectionManager, 
        Token token) throws IllegalActionException, CollectionException;

    CollectionHandler.TokenDisposition _handleDomainObject(CollectionManager 
        collectionManager, DomainObject object) throws IllegalActionException,
        CollectionException;

    CollectionHandler.TokenDisposition _handleExceptionToken(CollectionManager
        collectionManager, ExceptionToken token) throws IllegalActionException,
        CollectionException;
    
    void handleLoopTermination(LoopTerminationToken token) throws IllegalActionException;
    
    CollectionHandler.TokenDisposition _handleMetadata(CollectionManager collectionManager, 
        MetadataToken token) throws IllegalActionException, 
        CollectionException;

    void _handleParameterChange(Parameter parameter, Token value) 
        throws IllegalActionException;
    
    CollectionHandler collectionHandler();
    
    List attributeList();
}