/* TODO One line description of class.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors;

import org.nddp.util.Parameters;
import org.nddp.util.ProcessEnvironment;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ObjectToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.actor type="general"
 *
 *  @author Timothy M. McPhillips
 */

public class CreateProcessEnvironment extends TypedAtomicActor {

    /**
     * @throws NameDuplicationException 
     * @throws IllegalActionException 
     * 
     */

    public CreateProcessEnvironment(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);

        // create an ouput port for sending a reference to the new environment
        environment = new TypedIOPort(this, "environment", false, true);
        environment.setTypeEquals(BaseType.OBJECT);

        // create a parameter for specifying the name of the 
        processName = Parameters.stringParameter(this, "processName", "");
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public variables                  ////

    public Parameter processName;
    public TypedIOPort environment;

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////
    
    public void fire() throws IllegalActionException {
 
        // call superclass method
        super.fire();
        
        // create the process environment
        ProcessEnvironment processEnvironment = new ProcessEnvironment(null);
    
        // create a working directory named according to the processName parameter
        processEnvironment.createWorkingDirectory(Parameters.stringValue(processName));
    
        // package a reference to the environment in an object token
        Token token = new ObjectToken(processEnvironment);
 
        // send the token 
        environment.broadcast(token);
    }
    
    ///////////////////////////////////////////////////////////////////
    ////                    private variables                      ////
    
    private static final long serialVersionUID = 1L;
}
