/* TODO One line description of class.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors;

import org.nddp.util.Parameters;
import org.nddp.util.ProcessEnvironment;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ObjectToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.actor type="general"
 *
 *  @author Timothy M. McPhillips
 */

public class DestroyProcessEnvironment extends TypedAtomicActor {

    /**
     * @throws NameDuplicationException 
     * @throws IllegalActionException 
     * 
     */

    public DestroyProcessEnvironment(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);

        // create an input port for receiving a reference to the new environment
        environment = new TypedIOPort(this, "environment", true, false);
        environment.setTypeEquals(BaseType.OBJECT);
        
        // create parameter for specifying if working directory should be deleted
        deleteDirectory = Parameters.booleanParameter(this, "deleteDirectory", true);
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public variables                  ////

    public Parameter deleteDirectory;
    public TypedIOPort environment;

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////
    
    public void fire() throws IllegalActionException {
 
        // call superclass method
        super.fire();

        // receive one token on the input port
        ObjectToken token = (ObjectToken) environment.get(0);
        
        // extract the reference to the process environment
        ProcessEnvironment processEnvironment = (ProcessEnvironment) token.getValue();
    
        // optionally delete the working directory and its contents
        if (Parameters.booleanValue(deleteDirectory)) {
            processEnvironment.deleteWorkingDirectory();
        }
    }
    
    ///////////////////////////////////////////////////////////////////
    ////                    private variables                      ////
    
    private static final long serialVersionUID = 1L;
}
