/* Actor for reading a file from the external environment.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors;


import org.nddp.exceptions.ExternalEnvironmentException;
import org.nddp.util.Parameters;
import org.nddp.util.ProcessEnvironment;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.actor type="general"
 *
 *  @author Timothy M. McPhillips
 */

public class ReadFile extends EnvironmentActor {

    public ReadFile(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);

        // create an output port for sending file contents
        fileContentPort = new TypedIOPort(this, "fileContent", false, true);
        fileContentPort.setTypeEquals(BaseType.STRING);

        // create a parameter for specifying the name of the file
        fileName = 
            Parameters.stringParameter(this, "fileName", "infile");
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public variables                  ////

    TypedIOPort fileContentPort;
    public Parameter fileName;
    
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////
    
    
    public void fire() throws IllegalActionException {
        
        super.fire();
        
        // get a reference to the process environment
        ProcessEnvironment processEnvironment = receiveEnvironment();
                
        String fileContent;
        
        try {
            
            fileContent = processEnvironment.readFile(_fileName);
        } catch (ExternalEnvironmentException e) {
            throw new IllegalActionException("Error reading file: " + _fileName);
        }

        fileContentPort.broadcast(new StringToken(fileContent));
        
        // forward the process environment
        sendEnvironment();
    }

    public final void attributeChanged(Attribute attribute) 
        throws IllegalActionException {

        if (attribute == fileName) {
            
            _fileName = Parameters.stringValue(fileName);
    
        } else {

            super.attributeChanged(attribute);
        }
    }

    private String _fileName;
    private static final long serialVersionUID = 1L;
}
