/* TODO One line description of class.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors.phylip;

import java.util.LinkedList;
import java.util.List;

import org.nddp.actors.EnvironmentActor;
import org.nddp.exceptions.ExternalEnvironmentException;
import org.nddp.phylogeny.Tree;
import org.nddp.phylogeny.phylip.PhylipFiles;
import org.nddp.util.Parameters;
import org.nddp.util.Port;
import org.nddp.util.ProcessEnvironment;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.ObjectToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.actor type="phylogenetics"
 *
 *  @author Timothy M. McPhillips
 */

public class WritePhylipTrees extends EnvironmentActor {

    public WritePhylipTrees(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);

        // create an input port for receiving an array of phylogenetic trees
        treeArray = new TypedIOPort(this, "treeArray", true, false);
        treeArray.setTypeEquals(new ArrayType(BaseType.OBJECT));
        
        // create a parameter for optionally specifying the name of the trees file
        fileName = 
            Parameters.stringParameter(this, "fileName", "intree");
    }
    
    ///////////////////////////////////////////////////////////////////
    ////                         public variables                  ////

    public TypedIOPort treeArray;
    public Parameter fileName;
    
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////
    
    public final void attributeChanged(Attribute attribute) 
        throws IllegalActionException {
        
        if (attribute == fileName) {
        
            _fileName = Parameters.stringValue(fileName);
    
        } else {
            super.attributeChanged(attribute);
        }
    }        
    public void fire() throws IllegalActionException {
 
        // call superclass method
        super.fire();
        
        // get a reference to the process environment
        ProcessEnvironment processEnvironment = receiveEnvironment();

        // get an array token containing the trees
        Token[] tokenArray = Port.getTokenArray(treeArray, 0, true);
        
        // extract a tree from each token in array and add to list
        List treeList = new LinkedList();
        for (int i = 0; i < tokenArray.length; i++) {
            treeList.add((Tree)((ObjectToken)tokenArray[i]).getValue() );
        }
        
        // Write list of trees to an input file for Phylip
        try {
            PhylipFiles.writeTreeFile(
                    treeList, processEnvironment.createInputFile(_fileName));
        } catch (ExternalEnvironmentException e) {
            e.printStackTrace();
        }
        
        // forward the process environment
        sendEnvironment();
    }
    
    ///////////////////////////////////////////////////////////////////
    ////                    private variables                      ////

    private String _fileName;
    private static final long serialVersionUID = 1L;
}
