/* CollectionDisplay that displays only contents of string tokens.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp.coactors;

import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.exceptions.CollectionException;
import org.nddp.util.Parameters;

import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="general"
 */
public class TextDisplay extends CollectionDisplay  {

    public TextDisplay(CompositeEntity container, String name)
        throws IllegalActionException, NameDuplicationException {
        
        	super(container, name);
    }

	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 
	    
    public CollectionHandler.CollectionDisposition _handleCollectionStart(CollectionManager
        collectionManager) throws IllegalActionException, CollectionException {

		if (_clearDisplayOn.isInstance(collectionManager.collection())) {
		    _clearDisplay();
		}

   		return CollectionHandler.PROCESS_AND_DISCARD_COLLECTION;
   	}

  	
    public CollectionHandler.TokenDisposition _handleData(CollectionManager collectionManager, 
        Token token) throws IllegalActionException {
   	    
   	    if (token instanceof StringToken) {
   	        
   	        _appendText(Parameters.stringValue(token)); 
   	    }

        return CollectionHandler.DISCARD_TOKEN;
   	}
}
