/* Actor that removes redundant phylogenetic trees from Nexus collections.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
package org.nddp.coactors.phylogeny;
 
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.nddp.AtomicCoactor;
import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.DomainObject;
import org.nddp.coactors.CollectionTransformer;
import org.nddp.phylogeny.Tree;
import org.nddp.util.Parameters;

import ptolemy.data.IntToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="phylogenetics"
 */
public class UniqueTrees extends CollectionTransformer {

    public UniqueTrees(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException {
        
        	super(container, name);

        	Parameters.fix(collectionPath, "Nexus/Tree");
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    ////
    
    public void initialize() throws IllegalActionException {
 
        	super.initialize();
        	
        	_treeList.clear();
    }

	///////////////////////////////////////////////////////////////////
	////                      protected methods                    ////
    
    public void _handleCollectionEnd(CollectionManager collectionManager)
  		throws IllegalActionException {

		Tree.removeEquivalentTrees(_treeList);

		for (Iterator i = _treeList.iterator(); i.hasNext(); ) {
		    	Tree tree = (Tree)i.next();
    	    		collectionManager.addDomainObject(tree);
		}

		collectionManager.addMetadata("treeCount", 
		        new IntToken(_treeList.size()));

	    _treeList.clear();
    }
    
    public CollectionHandler.TokenDisposition _handleDomainObject(
        CollectionManager fileCollectionManager, DomainObject object) 
		throws IllegalActionException {

        _treeList.add(object);
        
        return  CollectionHandler.DISCARD_TOKEN;
    }
	
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

  	private List _treeList = new LinkedList();
}
