/* Runs clustalw.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

import org.nddp.exceptions.CollectionException;
import org.nddp.exceptions.ExternalEnvironmentException;
import org.nddp.phylogeny.CharacterMatrix;
import org.nddp.util.ProcessEnvironment;
import org.nddp.util.ProcessRunner;

public class ClustalRunner extends ProcessRunner {

    public ClustalRunner() {
        
        super();
   	}

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
	
	public Object run() throws CollectionException {
		
	    ProcessEnvironment environment = _createProcessEnvironment("CLUSTAL");
	    
	    _writeInputFiles(environment);
	    
	    _startProgram(environment, 
	    		System.getProperty("CLUSTAL_EXE_DIR") + "/clustalw -batch -infile=clustal.fasta");
	    
	    _waitForProgramCompletion();
	    
//	    Tree consensusTree = _parseOutputFiles(environment);
	    
	    _destroyEnvironment(environment);
		
//	    return consensusTree;
	    return null;
	}
		
	public void setCharacterMatrix(CharacterMatrix matrix) {
	    _characterMatrix = matrix;
	}
	
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////
        
    protected void _writeInputFiles(ProcessEnvironment environment) 
    		throws ExternalEnvironmentException {
        
	    try {
            writeFastaFile(_characterMatrix, environment.createInputFile("clustal.fasta"));
        } catch (IOException e) {
			throw new ExternalEnvironmentException("Error writing input file.");
        }
    }
    
    private Tree _parseOutputFiles(ProcessEnvironment environment)
    		throws CollectionException {

	    // Read the output tree file
	    String outtree = environment.readFile("clustal.aln");
		
	    return null;
    }

    ///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

	private CharacterMatrix _characterMatrix;

	///////////////////////////////////////////////////////////////////
	////                      private methods                      ////
	
	public static void writeFastaFile(CharacterMatrix matrix, 
        FileWriter fileWriter) throws IOException {

	    for (Iterator taxonIterator = matrix.taxonIterator(), 
	            rowIterator = matrix.rowIterator(); rowIterator.hasNext(); ) {
	        
	        String taxonName = (String)taxonIterator.next();
	        fileWriter.write(">" + taxonName + rowIterator.next() + "\n\n");
	    }
	    
	    fileWriter.close();
	}

}
