/* Base class for Phylip tree inference runners.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny.phylip;

import java.io.IOException;
import java.util.LinkedList;

import org.nddp.exceptions.CollectionException;
import org.nddp.exceptions.ExternalApplicationException;
import org.nddp.exceptions.ExternalEnvironmentException;
import org.nddp.exceptions.InconsistentDataException;
import org.nddp.phylogeny.Tree;
import org.nddp.util.ProcessEnvironment;
import org.nddp.util.ProcessRunner;

public class PhylipDrawgramRunner extends ProcessRunner {

    public PhylipDrawgramRunner() {
        
        super();
   	}

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

	public void rootAtNode(String name) {
	    _rootAtNode = name;
	}
	
	public Object run() throws CollectionException {
		
	    ProcessEnvironment environment = _createProcessEnvironment("DRAWGRAM");
	    
	    _writeInputFiles(environment);
	    
	    _startProgram(environment, 
	    		System.getProperty("PHYLIP_EXE_DIR") + "/drawgram");
	    
	    _writeStandardInput();

	    _waitForProgramCompletion();
		
	    return environment;
	}

	public void setTree(Tree tree) {
	    _tree = tree;
	}
    	
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////
        
    protected void _writeInputFiles(ProcessEnvironment environment) 
    		throws ExternalEnvironmentException, InconsistentDataException {
        
	    	LinkedList treeList = new LinkedList();
            
//	    	if (! _rootAtNode.equals("")) {
//	        Tree tree = (Tree)_tree.clone();
//		    tree.reroot(_rootAtNode);
//		    treeList.add(tree);
//	    } else {
		    	treeList.add(_tree);
//	    }
	    	
	    PhylipFiles.writeTreeFile(treeList, 
            environment.createInputFile("intree"));
    }
    
    protected void _writeStandardInput() 
    		throws ExternalApplicationException {
        
        
		try {
            	// sprecify the font file to use
		    _writeToProcess(System.getProperty("PHYLIP_EXE_DIR") + "/font3");

		    // specify custom output device (svg)
            	_writeToProcess("P");			
            	_writeToProcess("U");
            	
            	// specify width of svg canvas in cm 
           	_writeToProcess("14");			

           	// specify height of svg canvas in cm 
            	_writeToProcess("11");
            	
            	// request no preview device
            	_writeToProcess("V");			
            	_writeToProcess("N");			
            	
            	_writeToProcess("F");
            	_writeToProcess("Times");

		    	// accept configuration and begin execution
			_writeToProcess("Y");
		    	
		} catch (IOException e) {
			throw new ExternalApplicationException(
		        "Error writing to DRAWGRAM process");
        	}		    
    }

    ///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

	private String _rootAtNode;	
	private Tree _tree;
}
