/* Base classes for collection actors that run external programs.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.util;

import org.nddp.CollectionIOPort;
import org.nddp.coactors.CollectionTransformer;
import org.nddp.exceptions.CollectionException;
import org.nddp.exceptions.InconsistentDataException;
import org.nddp.tokens.ClosingDelimiterToken;
import org.nddp.tokens.OpeningDelimiterToken;

import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class ProcessRunningActor extends CollectionTransformer {

    public ProcessRunningActor(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException {
        
        	super(container, name);
    }
    
	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

//    public void handleClosingDelimiter(ClosingDelimiterToken token) 
//    		throws IllegalActionException {
//        
//    		super.handleClosingDelimiter(token);
//    		
//    		_writeStdio(token);
//    	}
//
//    public void handleOpeningDelimiter(OpeningDelimiterToken token) 
//    		throws IllegalActionException {
//        
//    		_writeStdio(token);
//        
//        	super.handleOpeningDelimiter(token);
//    	}
    
    public void initialize() throws IllegalActionException {
        
        super.initialize();
        
        _stdoutPort = _getOutputPortNamed("stdout");
        _stderrPort = _getOutputPortNamed("stderr");
    }
    
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////
    
    protected abstract void _configureRunner() 
    		throws InconsistentDataException;

    protected abstract ProcessRunner _getRunnerInstance();
    
    protected void _runProgram() throws IllegalActionException, 
 		CollectionException {
    
        	_runner = _getRunnerInstance();
        	
        	_configureRunner();
        	
        	if (_stdoutPort != null && 
        	        _stdoutPort.connectedPortList().size() > 0) {
        	    
			_runner.setStdoutStreamHandler(new StreamPortRouter(_stdoutPort));
        	}
        	
        	if (_stderrPort != null && 
        	        _stderrPort.connectedPortList().size() > 0) {
        	    
			_runner.setStderrStreamHandler(new StreamPortRouter(_stderrPort));
        	} 

        	_runResult = _runner.run();
    }

	///////////////////////////////////////////////////////////////////
	////                         protected variables               ////

    	protected ProcessRunner _runner;
	protected Object _runResult;
	
	///////////////////////////////////////////////////////////////////
	////                         private methods                   ////
          
    private void _writeStdio(Token token) throws IllegalActionException {
        
    		if (_stdoutPort != null) {
    		    _stdoutPort.send(token);
    		}
    		
    		if (_stderrPort != null) {
        		_stderrPort.send(token);
    		}
    }

	///////////////////////////////////////////////////////////////////
	////                       private variables                   ////

	private CollectionIOPort _stderrPort;
	private CollectionIOPort _stdoutPort;
}
