/* A certificate source.

 Copyright (c) 1998-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY

*/

package org.nmiworkflow;

import java.io.File;

import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.proxy.ext.ProxyCertInfo;

import ptolemy.actor.lib.Source;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import edu.sdsc.globusproxy.ProxyInitTool;

//////////////////////////////////////////////////////////////////////////
//// GlobusProxy
/**
Creates a Globus proxy certificate from an x509 key and certificate pair,
provided a passphrase. Right now it produces a pretty simple and default
proxy. This will be expanded on.

@author Stephen Mock
@version $Id: GlobusProxy.java,v 1.6 2005/11/01 20:39:14 ruland Exp $
@since Ptolemy II 0.2
*/

public class GlobusProxy extends Source {

    /** Construct a globusproxy source with the given container and name.
     *  Create the <i>x509cert</i> and <i>x509key</i> parameters, which point
     *  to the user's Globus certificate and keyfiles.
     *  (Note, I think there is some way to find the user's home dir? if so
     *  I should try to enter ~/.globus/*.pem in as the default)
     *  Create the <i>passphrase</i> parameter.
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the entity cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public GlobusProxy(CompositeEntity container, String name)
            throws NameDuplicationException, IllegalActionException  {
        super(container, name);
	cert = new FileParameter(this, "cert file");
	key  = new FileParameter(this, "key file");
        //cert = new Parameter(this, "x509cert", new StringToken("/enter/path/to/.globus/usercert.pem"));
        //key  = new Parameter(this, "x509key" , new StringToken("/enter/path/to/.globus/userkey.pem"));
        passphrase = new Parameter(this, "passphrase", new StringToken(""));

        // Set the type constraint.
        //output.setTypeAtLeast(cert);
	output.setTypeEquals(BaseType.STRING);

        _attachText("_iconDescription", "<svg>\n" +
                "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n" +
                "</svg>\n");
    }

    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////

    /** The value produced by this constant source.
     *  By default, it contains an StringToken with value something.  If the
     *  type of this token is changed during the execution of a model,
     *  then the director will be asked to redo type resolution.
     */
    public FileParameter cert;
    public FileParameter key;
    public Parameter passphrase;
    public ProxyInitTool init;
// USES: jce-jdk13-117.jar
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Clone the actor into the specified workspace. This calls the
     *  base class and then sets the value public variable in the new
     *  object to equal the cloned parameter in that new object.
     *  @param workspace The workspace for the new object.
     *  @return A new actor.
     *  @exception CloneNotSupportedException If a derived class contains
     *   an attribute that cannot be cloned.
     */
/********
    public Object clone(Workspace workspace)
            throws CloneNotSupportedException {
        GlobusProxy newObject = (GlobusProxy)super.clone(workspace);
        // Set the type constraint.
        newObject.output.setTypeAtLeast(newObject.cert);
        return newObject;

    }
********/

/*** seemed like a good idea at the time?
    public boolean prefire() throws IllegalActionException {
        return (_checkFile(cert.toString()) && _checkFile(key.toString()) && super.prefire());
    }
****/

    /** Send the token in the <i>value</i> parameter to the output.
     *  @exception IllegalActionException If it is thrown by the
     *   send() method sending out the token.
     */
    public void fire() throws IllegalActionException {
        super.fire();
        String pass = ((StringToken)passphrase.getToken()).stringValue();
        File temp = cert.asFile();
        String certFile = temp.getPath();
        temp = key.asFile();
        String keyFile = temp.getPath();
        //String certFile = ((FileParameter)cert.asFile()).stringValue();
        //String keyFile  = ((StringToken)key.getToken()).stringValue();
        //many of these could be made into parameters....
        int bits         = 512;
        int lifetime     = 3600 * 12;
        boolean debug    = false;
        boolean quiet    = false;
        boolean verify   = false;
        boolean pkcs11   = false;
        boolean limited  = false;
        int pathLen      = -1;
        int proxyType    = -1;
        String policyLanguage = null;
        String policyFile = null;

        CoGProperties properties = CoGProperties.getDefault();

        boolean useGsi3     = true;
        boolean globusStyle = false;
        String proxyFile    = properties.getProxyFile();

        ProxyInitTool init = new ProxyInitTool();

        CertUtil.init();

        ProxyCertInfo proxyCertInfo = null;

        init.setBits(bits);
        init.setLifetime(lifetime);

        //this may need to be a parameter as well
        //as things will probably evolve to gt3 over time
        proxyType = GSIConstants.GSI_2_PROXY;

        init.setProxyType(proxyType);
        init.setProxyCertInfo(proxyCertInfo);

        init.setDebug(debug);
        init.setQuiet(quiet);

        proxyString = init.createProxy(certFile,
                         keyFile,
                         pass,
                         verify,
                         globusStyle,
                        proxyFile);

        output.send(0, new StringToken(proxyString));
    }

    ///////////////////////////////////////////////////////////////////
    ////                        private methods                    ////

    String proxyString = null;

    private boolean _checkFile(String filename) {
        File f = new File(filename);
        if(! f.exists()) {
            return false;
        }
        else if(! f.canRead()) {
            return false;
        }
        return true;
    }
}
