/* GridFTP...

 Copyright (c) 2000-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.
 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.
 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
 */

package org.sdm.spa;

import java.io.IOException;

import org.globus.ftp.GridFTPClient;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;

//////////////////////////////////////////////////////////////////////////
//// GridFTP
/**
   This actor reads and writes from/to a file in a specified Globus machine
   and sends back the handle when it is done.

   @author Ilkay Altintas (Built on top of Steve Mock's GridFTP.)
   @version $Id: GridFTPUpdated.java,v 1.2 2005/11/01 20:39:14 ruland Exp $
*/

public class GridFTPUpdated extends Source {

  public GridFTPUpdated (CompositeEntity container, String name)
          throws IllegalActionException, NameDuplicationException {
      super(container, name);


      input = new TypedIOPort(this, "input", true, false);
      //input.setMultiport(true);
      input.setTypeEquals(BaseType.STRING);

      output.setTypeEquals(BaseType.STRING);

      sourceHost = new StringAttribute(this, "SourceHostname");
      sourceFile = new FileParameter(this, "Full path to source file");
      destHost = new StringAttribute(this, "DestinationHostname");
      destFile = new FileParameter(this, "Full path to destination file");

      _attachText("_iconDescription", "<svg>\n"
              + "<rect x=\"-25\" y=\"-20\" "
              + "width=\"50\" height=\"40\" "
              + "style=\"fill:white\"/>\n"
              + "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
              + " 15,-10 15,10, -15,10\" "
              + "style=\"fill:red\"/>\n"
              + "</svg>\n");
  }

  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////
  /** The input port, which is a multiport.
   */
  public TypedIOPort input;

  public StringAttribute sourceHost; //string of the source host gridFTP server
  public StringAttribute destHost;   //string of the destination host for the transfer
  public Parameter sourcePort; //port number for the server
  public Parameter destPort;   //port number for the dest
  public FileParameter sourceFile; //full path to the source file
  public FileParameter destFile  ; //full path to the destination file

  ///////////////////////////////////////////////////////////////////
  ////                         public methods                    ////

  /** If the specified attribute is <i>fileOrURL</i> and there is an
   *  open file being read, then close that file and open the new one;
   *  if the attribute is <i>numberOfLinesToSkip</i> and its value is
   *  negative, then throw an exception.  In the case of <i>fileOrURL</i>,
   *  do nothing if the file name is the same as the previous value of
   *  this attribute.
   *  @param attribute The attribute that has changed.
   *  @exception IllegalActionException If the specified attribute
   *   is <i>fileOrURL</i> and the file cannot be opened, or the previously
   *   opened file cannot be closed; or if the attribute is
   *   <i>numberOfLinesToSkip</i> and its value is negative.
   */
  public void attributeChanged(Attribute attribute)
          throws IllegalActionException {

      super.attributeChanged(attribute);
  }

  /** Output the data lines into an array.
   *  @exception IllegalActionException If there's no director.
   */

  public void fire() throws IllegalActionException {
      super.fire();

      //get the proxy string fed into the input port
      Token token = input.get(0);

      String sourceHostString = sourceHost.getExpression();
      _debug("Source hostname = " + sourceHostString);
      int sourcePort = 2811; //((IntToken)sourcePort.getToken()).intValue();
      String destHostString = destHost.getExpression();
      _debug("Source hostname = " + destHostString);
      int destPort = 2811; //((IntToken)destPort.getToken()).intValue();

      String failMsg = "GridFTP transfer failed because of: ";
      //_proxy = token.toString();
      try {
          ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
          _proxy = manager.createCredential((token.toString()).getBytes(),
                                ExtendedGSSCredential.IMPEXP_OPAQUE,
                                GSSCredential.DEFAULT_LIFETIME,
                                null, // use default mechanism - GSI
                                GSSCredential.INITIATE_AND_ACCEPT);

          if(destHostString.equals("") || destHostString.equals("localhost")) {
              _gftpc = new GridFTPClient(sourceHostString, sourcePort);
              _debug("1");
              _gftpc.authenticate(_proxy);
              _debug("2");
              _sourceFileString = sourceFile.getExpression();
              _debug("Source file path = " + _sourceFileString);
              //_gftpc.get(_sourceFileString, new File(_destFileString));
              _gftpc.get(_sourceFileString, destFile.asFile());
              _debug("3");
          } else if (sourceHostString.equals("") || sourceHostString.equals("localhost")) {
              _gftpc_dest = new GridFTPClient(destHostString, destPort);
              _debug("4");
              _gftpc_dest.authenticate(_proxy);
              _debug("5");
              _destFileString = destFile.getExpression();
              _debug("Dest file path = " + _destFileString);
              //_gftpc_dest.put(new File("c:\\temp.html"), _destFileString, false);
              _gftpc_dest.put(sourceFile.asFile(), _destFileString, false);
              _debug("6");
            }
            else {
              _sourceFileString = sourceFile.getExpression();
              _debug("Source file path = " + _sourceFileString);
              _destFileString = destFile.getExpression();
              _debug("Dest file path = " + _destFileString);
              _gftpc = new GridFTPClient(sourceHostString, sourcePort);
              _debug("7");
              _gftpc.authenticate(_proxy);
              _debug("8");
              _gftpc_dest = new GridFTPClient(destHostString, destPort);
              _debug("9");
              _gftpc_dest.authenticate(_proxy);
              _debug("10");
              _gftpc.transfer(_sourceFileString, _gftpc_dest, _destFileString, false, null);
              _debug("11");
          }
      } catch (IOException ioe) {
          throw new IllegalActionException(failMsg + ioe.toString());
      } catch (org.globus.ftp.exception.ServerException se) {
          throw new IllegalActionException(failMsg + se.toString());
      } catch (org.globus.ftp.exception.ClientException ce) {
          throw new IllegalActionException(failMsg + ce.toString());
      } catch (org.ietf.jgss.GSSException gsse) {
          throw new IllegalActionException(failMsg + gsse.toString());
      }
      _debug("Done with GridFTP transfer.");
      output.broadcast(new StringToken(_destFileString));
  }

  /** Post fire the actor. Return false to indicated that the
  * process has finished. If it returns true, the process will
  * continue indefinitely.
  */

  public boolean postfire() {
      return false;
  }

  /** Open the file or URL and read the first line, and use the
   *  first line to set the type of the output.
   *  @exception IllegalActionException If the file or URL cannot be
   *  opened, or if the first line cannot be read.
   */
  public void preinitialize() throws IllegalActionException {
      super.preinitialize();
  }

  /** Close the reader if there is one.
   *  @exception IllegalActionException If an IO error occurs.
   */
/********
  public void wrapup() throws IllegalActionException {
      fileOrURL.close();
      _reader = null;
  }
*********/

  ///////////////////////////////////////////////////////////////////
  ////                         protected members                 ////


  ///////////////////////////////////////////////////////////////////
  ////                         private methods                   ////


  ///////////////////////////////////////////////////////////////////
  ////                         private members                   ////

  private GridFTPClient _gftpc;
  private GridFTPClient _gftpc_dest;
  private GSSCredential _proxy;

  private String _destFileString;
  private String _sourceFileString;
  /** Result string Variable. */
  private String _result = new String("");

}
