/*
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *                                       PT_COPYRIGHT_VERSION_2
 *                                       COPYRIGHTENDKEY
 */


package org.sdm.spa;

import java.io.StringWriter;
import java.io.Writer;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerFactory;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.XMLToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;


//////////////////////////////////////////////////////////////////////////
//// XPath
/**
    XPath selects XML nodes based on the XPath syntax.

    This actor takes in an XPath string and an XMLToken, and it returns an
    array of XMLTokens.

    @author xiaowen
    @version $Id: XPath.java,v 1.4 2005/11/01 20:39:14 ruland Exp $
 */


public class XPath extends Transformer {

    /** Construct an XPath actor with the given container and name.
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public XPath(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException {

        super(container, name);

        portXPath = new PortParameter(this, "xpath");

        input.setTypeEquals(BaseType.XMLTOKEN);
        output.setTypeEquals(new ArrayType(BaseType.XMLTOKEN));
        portXPath.setTypeEquals(BaseType.STRING);

        _attachText(
            "_iconDescription",
            "<svg>\n"
                + "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n"
                + "</svg>\n");

    }


    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////

    public PortParameter portXPath;


    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////


    /** Clone the actor into the specified workspace.
     *  @param workspace The workspace for the new object.
     *  @return A new actor.
     *  @exception CloneNotSupportedException If a derived class contains
     *   an attribute that cannot be cloned.
     */
    /*public Object clone(Workspace workspace)
        throws CloneNotSupportedException {
        XPath newObject = (XPath) super.clone(workspace);

        // Set the type constraints.
        newObject.input.setTypeEquals(BaseType.XMLTOKEN);
        newObject.output.setTypeEquals(new ArrayType(BaseType.XMLTOKEN));

        return newObject;
    }*/


    /** Take in an XMLToken and the XPath expression, and return an ArrayToken
     *  containing XMLTokens representing the result of selecting nodes using
     *  the XPath expression.
     *  @exception IllegalActionException If it can't select nodes using the
     *      XPath expression or if it's unable to create the resulting
     *      XMLTokens.
     */
    public void fire() throws IllegalActionException {
        super.fire();

        // get inputs
        XMLToken tokenXml = (XMLToken) input.get(0);
        portXPath.update();
        String strXPath = ((StringToken) portXPath.getToken()).stringValue();
        _debug("The XPath expression is: " + strXPath);

        // run XPath on it
        Node nodeRoot = tokenXml.getDomTree().getDocumentElement().getFirstChild();
        NodeList nodeHits = null;

        try {
            nodeHits = XPathAPI.selectNodeList(nodeRoot, strXPath);
        } catch(javax.xml.transform.TransformerException e) {
            throw new IllegalActionException("XPath: could not select nodes.");
        }

        // format the results
        XMLToken arrTokens[] = new XMLToken[nodeHits.getLength()];

        SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory("xml");
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setOmitXMLDeclaration(true);
        XMLSerializer xmlSerializer = (XMLSerializer)serializerFactory.makeSerializer(outputFormat);

        for(int i = 0; i < nodeHits.getLength(); i++) {
            Writer stringWriter = new StringWriter();
            xmlSerializer.setOutputCharStream(stringWriter);

            Node node = nodeHits.item(i);
            if (Node.ELEMENT_NODE != node.getNodeType()) {
                throw new IllegalActionException("XPath: node selected with XPath isn't an element.");
            }

            try {
                xmlSerializer.serialize((Element)node);
            } catch(java.io.IOException e) {
                throw new IllegalActionException("XPath: java.io.IOException ...");
            }

            try {
                arrTokens[i] = new XMLToken(stringWriter.toString());
            } catch(java.lang.Exception e) {
                throw new IllegalActionException("XPath: unable to create XMLToken with string: " +
                    stringWriter.toString());
            }
        }

        // If there were no results, then send out a dummy xml token.
        // This is really a hack.  The ideal solution for this actor would be
        // able to send out an empty ArrayToken.
        if (0 == arrTokens.length) {
            arrTokens = new XMLToken[1];
            try {
                arrTokens[0] = new XMLToken("<dummy/>");
            } catch(java.lang.Exception e) {
                // well this really shouldn't happen.
                throw new IllegalActionException("XPath: '<dummy/>' apparently isn't valid XML");
            }
        }

        // send out the results
        output.send(0, new ArrayToken(arrTokens));
    }

}

// vim: ts=4 sw=4 et
