/*
 * A Dataset Training actor from SKIDLkit @ SDSC...
 *
 * Copyright (c) 2000-2003 The Regents of the University of California. All
 * rights reserved. Permission is hereby granted, without written agreement and
 * without license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the above
 * copyright notice and the following two paragraphs appear in all copies of
 * this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN
 * "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * PT_COPYRIGHT_VERSION_2 COPYRIGHTENDKEY
 */
package org.skidlkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.gui.MessageHandler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
//////////////////////////////////////////////////////////////////////////
////Trainer
/**
 * This actor pass two local input file names to the SKIDLkit classification
 * tools through the Java System Call to first train a data set, and then
 * classify the given dataset, finally it output the classified data result.
 *
 * @author Longjiang Ding
 * @version $Id: Trainer.java,v 1.3 2004/08/10 04:51:13 berkley Exp $
 */
public class Trainer extends TypedAtomicActor {
	/**
	 * Construct a Trainer actor with the given container and name.
	 *
	 * @param container
	 *            The container.
	 * @param name
	 *            The name of this actor.
	 * @exception IllegalActionException
	 *                If the actor cannot be contained by the proposed
	 *                container.
	 * @exception NameDuplicationException
	 *                If the container already has an actor with this name.
	 */
	public Trainer(CompositeEntity container, String name)
			throws IllegalActionException, NameDuplicationException {
		super(container, name);
		in_filename = new TypedIOPort(this, "in_filename", true, false);
		in_filename.setTypeEquals(BaseType.STRING);
		in_datafilename = new TypedIOPort(this, "in_datafilename", true, false);
		in_datafilename.setTypeEquals(BaseType.STRING);
		out_filename = new TypedIOPort(this, "out_filename", false, true);
		out_filename.setTypeEquals(BaseType.STRING);
	} // end of constructor
	///////////////////////////////////////////////////////////////////
	//// ports and parameters ////
	/**
	 * The local input & output file names
	 */
	public TypedIOPort in_filename;
	public TypedIOPort in_datafilename;
	public TypedIOPort out_filename;
	///////////////////////////////////////////////////////////////////

	private int processExitValue; // flag: = 0, external process normal terminate
								  //      != 0, abornomal terminate
	//// public methods ////
	/**
	 * Read the input file name string if it is other than null, and then fire
	 * the external executable code ...
	 * Assume the filter.c and training data file are in the same folder
	 *
	 * @exception IllegalActionException
	 *                If there's no director.
	 */
	public void fire() throws IllegalActionException {
		try {
			if (in_filename.hasToken(0) && in_datafilename.hasToken(0)) {
				//If the inputToken is null set reFire to false.
				StringToken inToken = null, inDataToken = null;
				try {
					inToken = (StringToken) in_filename.get(0);
					inDataToken = (StringToken)in_datafilename.get(0);
				} catch (Exception ex) {
				}
				if (inToken != null && inDataToken != null) {
					// set up command
					//String filepath = "C:\\ljworks\\development\\SVM\\";
					File file = new File(inToken.toString());
					String filepath = file.getParent().substring(1) + "\\";
					System.out.println("FilePath = " + filepath);
					String mycommand = "C:/project/kepler/workflows/skidl/filter.exe -norm 0 0 -form 2 2 -algo 1 1 -feat 20 20 -file ";
					mycommand = mycommand + (inToken.stringValue()).substring(6)
                                                  + " -file_test " + (inDataToken.stringValue()).substring(6);
                                        _debug("<MY_COMMAND>" + mycommand + "</MY_COMMAND>");
					// start to call the SVM code by initiating the external
					// process
					processExitValue = -1;
					Process process = null;
					try {
						// create 'command' process
						process = Runtime.getRuntime().exec(mycommand);
						// Java-C communication
						while (process.getOutputStream() == null) {
						} // wait for Fortran in_filename
						PrintWriter fstdin = new PrintWriter(process
								.getOutputStream(), true);
/*						// send data to the external code via standard I/O
						for (int i = 0; i < in_filenameData.length; i++)
							fstdin.println(in_filenameData[i]); */
						// obtain error information of external process if any
						BufferedReader fstderr = new BufferedReader(
								new InputStreamReader(process.getErrorStream()));
						String ferr = null, lerr = null;
						while ((lerr = fstderr.readLine()) != null)
							ferr = ferr + "\n" + lerr;
						if (ferr != null) { // send external process error (if
							// any) to client
							System.out.println("Error message from external process: "+ferr);
							fstdin.close();
							process.destroy();
							return;
						}
						process.waitFor();
						fstdin.close();
						processExitValue = process.exitValue();
						//				System.out.println(command+" processExitValue = " +
						// processExitValue);
						//output the result file
						System.out.println("Process Exit Value = " + processExitValue);
						out_filename.send(0, new StringToken(filepath+"kepler_results.dat"));
						//System.out.println("Output File: "+ filepath+"SVM_output_file_test2.dat");
					} catch (InterruptedException ie) {
						System.out.println("Failed to create Process \"" + mycommand
								+ " for filter.c");
					} catch (IOException ioe) {
						System.out.println("Illegal I/O operation in Trainer Model. ");
					}
				} else {
					System.out.println("NoTokenException");
				}
			}
		} catch (Exception e) {
			MessageHandler
					.error(
							"Error opening/updating one of the input parameters: ",
							e);
		}
	} // end of fire
}