/* Database utilities class.

@Copyright (c) 2002-2003 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in all
copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                                PT_COPYRIGHT_VERSION 2
                                                COPYRIGHTENDKEY
*/

package util;

import java.util.*;

//////////////////////////////////////////////////////////////////////////
//// DBUtil
/**

@author Efrat Jaeger
@version $Id: DBUtil.java,v 1.2 2005/01/17 01:32:07 jaeger Exp $
@since Ptolemy II 4.0.1
*/
public class DBUtil {

    public DBUtil() {}

    private static Map drivers = new TreeMap();

    static {
        drivers.put("oracle", "oracle.jdbc.driver.OracleDriver");
        drivers.put("db2", "com.ibm.db2.jcc.DB2Driver");
        drivers.put("local ms access", "sun.jdbc.odbc.JdbcOdbcDriver");
        drivers.put("remote ms access", "org.objectweb.rmijdbc.Driver");
        drivers.put("ms sql server", "com.microsoft.jdbc.sqlserver.SQLServerDriver");
        drivers.put("postgresql", "org.postgresql.Driver");
        drivers.put("mysql", "com.mysql.jdbc.Driver");
    }

    public static String get(String dbFormat) {
        if (drivers.containsKey(dbFormat)) {
            return (String) drivers.get(dbFormat);
        } else return "";
    }

}
