/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.algorithms.encryption.EncryptionMethod;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.ContentHandlerAlreadyRegisteredException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.implementations.FuncHere;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.PRNG;
import org.apache.xml.security.utils.Version;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.compiler.FuncLoader;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Init {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$Init == null ? (class$org$apache$xml$security$Init = Init.class$("org.apache.xml.security.Init")) : class$org$apache$xml$security$Init).getName());
    private static boolean _alreadyInitialized = false;
    public static HashMap _contentHandlerHash;
    static /* synthetic */ Class class$org$apache$xml$security$Init;
    static /* synthetic */ Class class$org$apache$xml$security$transforms$implementations$FuncHere;

    public static final boolean isInitialized() {
        return _alreadyInitialized;
    }

    public static synchronized void init() {
        if (!_alreadyInitialized) {
            _alreadyInitialized = true;
            try {
                Object object;
                Object object2;
                Object[] objectArray;
                Object object3;
                Object[] objectArray2;
                long l = System.currentTimeMillis();
                long l2 = System.currentTimeMillis();
                PRNG.init(new SecureRandom());
                long l3 = System.currentTimeMillis();
                long l4 = System.currentTimeMillis();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputStream inputStream = Class.forName("org.apache.xml.security.Init").getResourceAsStream("resource/config.xml");
                Document document = documentBuilder.parse(inputStream);
                long l5 = System.currentTimeMillis();
                Element element = document.createElementNS(null, "nscontext");
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "http://www.xmlsecurity.org/NS/#configuration");
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:log4j", "http://jakarta.apache.org/log4j/");
                long l6 = System.currentTimeMillis();
                Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//log4j:configuration[1]", (Node)element);
                try {
                    String string;
                    File file;
                    Attr attr = (Attr)XPathAPI.selectSingleNode((Node)element2, (String)"./x:appender[@name='STDOUT']/x:param[@name='File']/@value", (Node)element);
                    if (attr != null && (file = new File(string = attr.getNodeValue())).exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DOMConfigurator.configure((Element)element2);
                cat.info((Object)"Logging is working");
                cat.info((Object)("Date: " + new Date(System.currentTimeMillis()).toString()));
                cat.info((Object)("Version: " + Version.getVersion()));
                long l7 = System.currentTimeMillis();
                long l8 = System.currentTimeMillis();
                Attr attr = (Attr)XPathAPI.selectSingleNode((Node)document, (String)"/x:Configuration/x:ResourceBundles/@defaultLanguageCode", (Node)element);
                Attr attr2 = (Attr)XPathAPI.selectSingleNode((Node)document, (String)"/x:Configuration/x:ResourceBundles/@defaultCountryCode", (Node)element);
                String string = attr == null ? null : attr.getNodeValue();
                String string2 = attr2 == null ? null : attr2.getNodeValue();
                I18n.init(string, string2);
                long l9 = System.currentTimeMillis();
                long l10 = System.currentTimeMillis();
                FunctionTable.installFunction((String)"here", (Expression)new FuncHere());
                cat.debug((Object)("Registered class " + (class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = Init.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName() + " for XPath function 'here()' function in internal table"));
                FuncHereLoader funcHereLoader = new FuncHereLoader();
                int n = 0;
                while (n < FunctionTable.m_functions.length) {
                    FuncLoader funcLoader = FunctionTable.m_functions[n];
                    if (funcLoader != null) {
                        cat.debug((Object)("Func " + n + " " + funcLoader.getName()));
                        if (funcLoader.getName().equals(funcHereLoader.getName())) {
                            FunctionTable.m_functions[n] = funcHereLoader;
                        }
                    }
                    ++n;
                }
                long l11 = System.currentTimeMillis();
                long l12 = System.currentTimeMillis();
                Canonicalizer.init();
                NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:CanonicalizationMethods/x:CanonicalizationMethod", (Node)element);
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    String string3 = ((Element)nodeList.item(n2)).getAttributeNS(null, "URI");
                    String string4 = ((Element)nodeList.item(n2)).getAttributeNS(null, "JAVACLASS");
                    boolean bl = true;
                    try {
                        Class<?> clazz = Class.forName(string4);
                        objectArray2 = clazz.getMethods();
                        int n3 = 0;
                        while (n3 < objectArray2.length) {
                            object3 = objectArray2[n3];
                            if (((Method)object3).getDeclaringClass().getName().equals(string4)) {
                                cat.debug(((Method)object3).getDeclaringClass());
                            }
                            ++n3;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        objectArray2 = new Object[]{string3, string4};
                        cat.fatal((Object)I18n.translate("algorithm.classDoesNotExist", objectArray2));
                        bl = false;
                    }
                    if (bl) {
                        cat.debug((Object)("Canonicalizer.register(" + string3 + ", " + string4 + ")"));
                        Canonicalizer.register(string3, string4);
                    }
                    ++n2;
                }
                long l13 = System.currentTimeMillis();
                long l14 = System.currentTimeMillis();
                Transform.init();
                NodeList nodeList2 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:TransformAlgorithms/x:TransformAlgorithm", (Node)element);
                int n4 = 0;
                while (n4 < nodeList2.getLength()) {
                    objectArray2 = ((Element)nodeList2.item(n4)).getAttributeNS(null, "URI");
                    String string5 = ((Element)nodeList2.item(n4)).getAttributeNS(null, "JAVACLASS");
                    boolean bl = true;
                    try {
                        Class<?> clazz = Class.forName(string5);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Object[] objectArray3 = new Object[]{objectArray2, string5};
                        cat.fatal((Object)I18n.translate("algorithm.classDoesNotExist", objectArray3));
                        bl = false;
                    }
                    if (bl) {
                        cat.debug((Object)("Transform.register(" + (String)objectArray2 + ", " + string5 + ")"));
                        Transform.register((String)objectArray2, string5);
                    }
                    ++n4;
                }
                long l15 = System.currentTimeMillis();
                long l16 = System.currentTimeMillis();
                object3 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"/x:Configuration/x:JCEAlgorithmMappings", (Node)element);
                JCEMapper.init((Element)object3);
                long l17 = System.currentTimeMillis();
                long l18 = System.currentTimeMillis();
                SignatureAlgorithm.providerInit();
                NodeList nodeList3 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:SignatureAlgorithms/x:SignatureAlgorithm", (Node)element);
                int n5 = 0;
                while (n5 < nodeList3.getLength()) {
                    String string6 = ((Element)nodeList3.item(n5)).getAttributeNS(null, "URI");
                    String string7 = ((Element)nodeList3.item(n5)).getAttributeNS(null, "JAVACLASS");
                    boolean bl = true;
                    try {
                        Class<?> clazz = Class.forName(string7);
                        objectArray = clazz.getMethods();
                        int n6 = 0;
                        while (n6 < objectArray.length) {
                            object2 = objectArray[n6];
                            if (((Method)object2).getDeclaringClass().getName().equals(string7)) {
                                cat.debug(((Method)object2).getDeclaringClass());
                            }
                            ++n6;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        objectArray = new Object[]{string6, string7};
                        cat.fatal((Object)I18n.translate("algorithm.classDoesNotExist", objectArray));
                        bl = false;
                    }
                    if (bl) {
                        cat.debug((Object)("SignatureAlgorithm.register(" + string6 + ", " + string7 + ")"));
                        SignatureAlgorithm.register(string6, string7);
                    }
                    ++n5;
                }
                long l19 = System.currentTimeMillis();
                long l20 = System.currentTimeMillis();
                ResourceResolver.init();
                NodeList nodeList4 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:ResourceResolvers/x:Resolver", (Node)element);
                int n7 = 0;
                while (n7 < nodeList4.getLength()) {
                    objectArray = ((Element)nodeList4.item(n7)).getAttributeNS(null, "JAVACLASS");
                    String string8 = ((Element)nodeList4.item(n7)).getAttributeNS(null, "DESCRIPTION");
                    if (string8 != null && string8.length() > 0) {
                        cat.debug((Object)("Register Resolver: " + (String)objectArray + ": " + string8));
                    } else {
                        cat.debug((Object)("Register Resolver: " + (String)objectArray + ": For unknown purposes"));
                    }
                    ResourceResolver.register((String)objectArray);
                    ++n7;
                }
                long l21 = System.currentTimeMillis();
                long l22 = System.currentTimeMillis();
                try {
                    KeyInfo.init();
                    _contentHandlerHash = new HashMap(10);
                    object2 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:KeyInfo/x:ContentHandler", (Node)element);
                    int n8 = 0;
                    while (n8 < object2.getLength()) {
                        String string9 = ((Element)object2.item(n8)).getAttributeNS(null, "NAMESPACE");
                        String string10 = ((Element)object2.item(n8)).getAttributeNS(null, "LOCALNAME");
                        object = ((Element)object2.item(n8)).getAttributeNS(null, "JAVACLASS");
                        cat.debug((Object)("KeyInfoContent: " + string9 + " " + string10 + " " + (String)object));
                        Init.registerKeyInfoContentHandler(string9, string10, (String)object);
                        ++n8;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                long l23 = System.currentTimeMillis();
                long l24 = System.currentTimeMillis();
                KeyResolver.init();
                object = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:KeyResolver/x:Resolver", (Node)element);
                int n9 = 0;
                while (n9 < object.getLength()) {
                    String string11 = ((Element)object.item(n9)).getAttributeNS(null, "JAVACLASS");
                    String string12 = ((Element)object.item(n9)).getAttributeNS(null, "DESCRIPTION");
                    if (string12 != null && string12.length() > 0) {
                        cat.debug((Object)("Register Resolver: " + string11 + ": " + string12));
                    } else {
                        cat.debug((Object)("Register Resolver: " + string11 + ": For unknown purposes"));
                    }
                    KeyResolver.register(string11);
                    ++n9;
                }
                long l25 = System.currentTimeMillis();
                long l26 = System.currentTimeMillis();
                cat.debug((Object)"Now I try to bind prefixes:");
                NodeList nodeList5 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:PrefixMappings/x:PrefixMapping", (Node)element);
                int n10 = 0;
                while (n10 < nodeList5.getLength()) {
                    String string13 = ((Element)nodeList5.item(n10)).getAttributeNS(null, "namespace");
                    String string14 = ((Element)nodeList5.item(n10)).getAttributeNS(null, "prefix");
                    cat.debug((Object)("Now I try to bind " + string14 + " to " + string13));
                    ElementProxy.setDefaultPrefix(string13, string14);
                    ++n10;
                }
                long l27 = System.currentTimeMillis();
                long l28 = System.currentTimeMillis();
                EncryptionMethod.providerInit();
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#kw-tripledes", "org.apache.xml.security.algorithms.encryption.implementations.BC.KeyWrapImpl_TRIPLEDES_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#kw-aes128", "org.apache.xml.security.algorithms.encryption.implementations.BC.KeyWrapImpl_AES128_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#kw-aes192", "org.apache.xml.security.algorithms.encryption.implementations.BC.KeyWrapImpl_AES192_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#kw-aes256", "org.apache.xml.security.algorithms.encryption.implementations.BC.KeyWrapImpl_AES256_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "org.apache.xml.security.algorithms.encryption.implementations.BC.BlockEncryptionImpl_TRIPLEDES_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "org.apache.xml.security.algorithms.encryption.implementations.BC.BlockEncryptionImpl_AES128_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "org.apache.xml.security.algorithms.encryption.implementations.BC.BlockEncryptionImpl_AES192_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "org.apache.xml.security.algorithms.encryption.implementations.BC.BlockEncryptionImpl_AES256_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "org.apache.xml.security.algorithms.encryption.implementations.BC.KeyTransportImpl_RSAOAEP_BC");
                EncryptionMethod.register("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "org.apache.xml.security.algorithms.encryption.implementations.BC.KeyTransportImpl_RSAPKCS15_BC");
                long l29 = System.currentTimeMillis();
                long l30 = System.currentTimeMillis();
                cat.debug((Object)("XX_init                             " + (int)(l30 - l) + " ms"));
                cat.debug((Object)("  XX_configure_reg_encryption       " + (int)(l29 - l28) + " ms"));
                cat.debug((Object)("  XX_prng                           " + (int)(l3 - l2) + " ms"));
                cat.debug((Object)("  XX_parsing                        " + (int)(l5 - l4) + " ms"));
                cat.debug((Object)("  XX_configure_i18n                 " + (int)(l9 - l8) + " ms"));
                cat.debug((Object)("  XX_configure_log4j                " + (int)(l7 - l6) + " ms"));
                cat.debug((Object)("  XX_configure_reg_c14n             " + (int)(l13 - l12) + " ms"));
                cat.debug((Object)("  XX_configure_reg_here             " + (int)(l11 - l10) + " ms"));
                cat.debug((Object)("  XX_configure_reg_jcemapper        " + (int)(l17 - l16) + " ms"));
                cat.debug((Object)("  XX_configure_reg_keyInfo          " + (int)(l23 - l22) + " ms"));
                cat.debug((Object)("  XX_configure_reg_keyResolver      " + (int)(l25 - l24) + " ms"));
                cat.debug((Object)("  XX_configure_reg_prefixes         " + (int)(l27 - l26) + " ms"));
                cat.debug((Object)("  XX_configure_reg_resourceresolver " + (int)(l21 - l20) + " ms"));
                cat.debug((Object)("  XX_configure_reg_sigalgos         " + (int)(l19 - l18) + " ms"));
                cat.debug((Object)("  XX_configure_reg_transforms       " + (int)(l15 - l14) + " ms"));
            }
            catch (Exception exception) {
                cat.fatal((Object)"Bad: ", (Throwable)exception);
                exception.printStackTrace();
            }
        }
    }

    public static void readUserConfiguration() throws XMLSecurityException {
        try {
            String string = System.getProperty("user.home") + "/" + ".xmlsecurityconfig";
            FileInputStream fileInputStream = new FileInputStream(string);
            Init.readUserConfiguration(fileInputStream);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public static void readUserConfiguration(String string) throws XMLSecurityException {
        try {
            InputStream inputStream = null;
            File file = new File(string);
            inputStream = file.exists() ? new FileInputStream(file) : new URL(string).openStream();
            Init.readUserConfiguration(inputStream);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public static void readUserConfiguration(InputStream inputStream) throws XMLSecurityException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = XMLUtils.createDSctx(document, "x", "http://www.xmlsecurity.org/NS/#configuration");
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"/x:AppConfiguration/x:KeyStore", (Node)element);
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getAttributeNS(null, "URI");
                String string2 = element2.getAttributeNS(null, "Type");
                String string3 = element2.getAttributeNS(null, "DefaultKeyAlias");
                String string4 = element2.getAttributeNS(null, "StorePass");
                String string5 = element2.getAttributeNS(null, "KeyPass");
                ++n;
            }
        }
        catch (Exception exception) {
            throw new XMLSecurityException("generic.EmptyMessage", exception);
        }
    }

    public static void registerKeyInfoContentHandler(String string, String string2, String string3) throws ContentHandlerAlreadyRegisteredException {
        String string4 = Init.qualifyNamespace(string, string2);
        if (_contentHandlerHash.containsKey(string4)) {
            cat.error((Object)"Already registered");
            Object[] objectArray = new Object[]{string4, (String)_contentHandlerHash.get(string4)};
            throw new ContentHandlerAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        HashMap hashMap = _contentHandlerHash;
        synchronized (hashMap) {
            _contentHandlerHash.put(string4, string3);
            cat.debug((Object)("Init._contentHandlerHash.put(\"" + string4 + "\", \"" + string3 + "\")"));
            cat.debug((Object)("Init._contentHandlerHash.size()=" + _contentHandlerHash.size()));
        }
    }

    private static String qualifyNamespace(String string, String string2) {
        return "{" + string + "}" + string2;
    }

    public static String getKeyInfoContentHandler(String string, String string2) {
        String string3 = Init.qualifyNamespace(string, string2);
        cat.debug((Object)("Asked for handler for " + string3));
        if (_contentHandlerHash == null) {
            cat.debug((Object)"But I can't help (hash==null) ");
            return null;
        }
        if (_contentHandlerHash.size() == 0) {
            cat.debug((Object)"But I can't help (size()==0)");
            return null;
        }
        Set set = _contentHandlerHash.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (!string4.equals(string3)) continue;
            return (String)_contentHandlerHash.get(string4);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FuncHereLoader
    extends FuncLoader {
        static /* synthetic */ Class class$org$apache$xml$security$transforms$implementations$FuncHere;

        public FuncHereLoader() {
            super((class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = FuncHereLoader.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName(), 0);
        }

        public Function getFunction() throws TransformerException {
            return new FuncHere();
        }

        public String getName() {
            return (class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = FuncHereLoader.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

