/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.helper;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.xml.security.algorithms.encryption.helper.InvalidCipherTextException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.HexDump;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class OAEPCipher {
    Cipher _cipher;
    int _cipherMode;
    MessageDigest _digest;
    int _hLen;
    byte[] _encodingParams;
    byte[] _encodingParamsHash;
    SecureRandom _secureRandom;

    public OAEPCipher(Cipher cipher, MessageDigest messageDigest, byte[] byArray) {
        this._cipher = cipher;
        this._digest = messageDigest;
        this._hLen = this._digest.getDigestLength();
        this._encodingParams = byArray != null ? byArray : new byte[0];
        this._digest.reset();
        this._digest.update(this._encodingParams);
        this._encodingParamsHash = this._digest.digest();
        this._digest.reset();
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this._cipherMode = n;
        this._secureRandom = secureRandom;
        this._cipher.init(this._cipherMode, key, this._secureRandom);
    }

    public int getInputBlockSize() {
        int n = this._cipher.getBlockSize();
        int n2 = this._digest.getDigestLength();
        if (this._cipherMode == 1) {
            return n - 1 - 2 * n2;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this._cipher.getBlockSize();
        int n2 = this._digest.getDigestLength();
        if (this._cipherMode == 1) {
            return n;
        }
        return n - 1 - 2 * n2;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        if (this._cipherMode == 1) {
            return this.encodeBlock(byArray, n, n2);
        }
        if (this._cipherMode == 2) {
            return this.decodeBlock(byArray, n, n2);
        }
        return null;
    }

    public byte[] encodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this._hLen];
        System.arraycopy(byArray, n, byArray2, byArray2.length - n2, n2);
        byArray2[byArray2.length - n2 - 1] = 1;
        System.arraycopy(this._encodingParamsHash, 0, byArray2, this._hLen, this._hLen);
        byte[] byArray3 = new byte[this._hLen];
        this._secureRandom.nextBytes(byArray3);
        byte[] byArray4 = OAEPCipher.maskGeneratorFunction1(byArray3, 0, byArray3.length, byArray2.length - this._hLen, this._digest);
        int n3 = this._hLen;
        while (n3 != byArray2.length) {
            int n4 = n3;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray4[n3 - this._hLen]);
            ++n3;
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this._hLen);
        byArray4 = OAEPCipher.maskGeneratorFunction1(byArray2, this._hLen, byArray2.length - this._hLen, this._hLen, this._digest);
        int n5 = 0;
        while (n5 != this._hLen) {
            int n6 = n5;
            byArray2[n6] = (byte)(byArray2[n6] ^ byArray4[n5]);
            ++n5;
        }
        return this._cipher.doFinal(byArray2, 0, byArray2.length);
    }

    public byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = this._cipher.doFinal(byArray, n, n2);
        byte[] byArray3 = null;
        if (byArray2.length < this.getOutputBlockSize()) {
            byArray3 = new byte[this.getOutputBlockSize()];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        } else {
            byArray3 = byArray2;
        }
        if (byArray3.length < 2 * this._hLen + 1) {
            throw new InvalidCipherTextException("encryption.RSAOAEP.dataTooShort");
        }
        byte[] byArray4 = OAEPCipher.maskGeneratorFunction1(byArray3, this._hLen, byArray3.length - this._hLen, this._hLen, this._digest);
        int n3 = 0;
        while (n3 != this._hLen) {
            int n4 = n3;
            byArray3[n4] = (byte)(byArray3[n4] ^ byArray4[n3]);
            ++n3;
        }
        byArray4 = OAEPCipher.maskGeneratorFunction1(byArray3, 0, this._hLen, byArray3.length - this._hLen, this._digest);
        int n5 = this._hLen;
        while (n5 != byArray3.length) {
            int n6 = n5;
            byArray3[n6] = (byte)(byArray3[n6] ^ byArray4[n5 - this._hLen]);
            ++n5;
        }
        int n7 = 0;
        while (n7 != this._encodingParamsHash.length) {
            if (this._encodingParamsHash[n7] != byArray3[this._encodingParamsHash.length + n7]) {
                throw new InvalidCipherTextException("encryption.RSAOAEP.dataHashWrong");
            }
            ++n7;
        }
        int n8 = 2 * this._hLen;
        while (n8 != byArray3.length) {
            if (byArray3[n8] == 1 || byArray3[n8] != 0) break;
            ++n8;
        }
        if (n8 >= byArray3.length - 1 || byArray3[n8] != 1) {
            Object[] objectArray = new Object[]{new Integer(n8)};
            throw new InvalidCipherTextException("encryption.RSAOAEP.dataStartWrong", objectArray);
        }
        byte[] byArray5 = new byte[byArray3.length - ++n8];
        System.arraycopy(byArray3, n8, byArray5, 0, byArray5.length);
        return byArray5;
    }

    static void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    static byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3, MessageDigest messageDigest) throws IllegalArgumentException {
        byte[] byArray2;
        int n4 = messageDigest.getDigestLength();
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[4];
        int n5 = 0;
        messageDigest.reset();
        do {
            OAEPCipher.ItoOSP(n5, byArray4);
            messageDigest.update(byArray, n, n2);
            messageDigest.update(byArray4, 0, byArray4.length);
            byArray2 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray3, n5 * n4, n4);
        } while (++n5 < n3 / n4);
        if (n5 * n4 < n3) {
            OAEPCipher.ItoOSP(n5, byArray4);
            messageDigest.update(byArray, n, n2);
            messageDigest.update(byArray4, 0, byArray4.length);
            byArray2 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray3, n5 * n4, byArray3.length - n5 * n4);
        }
        return byArray3;
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("RSA", "BC");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", "BC");
        byte[] byArray = Base64.decode("9lWu3Q==");
        OAEPCipher oAEPCipher = new OAEPCipher(cipher, messageDigest, null);
        BigInteger bigInteger = new BigInteger("bbf82f090682ce9c2338ac2b9da871f7368d07eed41043a440d6b6f07454f51fb8dfbaaf035c02ab61ea48ceeb6fcd4876ed520d60e1ec4619719d8a5b8b807fafb8e0a3dfc737723ee6b4b7d93a2584ee6a649d060953748834b2454598394ee0aab12d7b61a51f527a9a41f6c1687fe2537298ca2a8f5946f8e5fd091dbdcb", 16);
        BigInteger bigInteger2 = new BigInteger("a5dafc5341faf289c4b988db30c1cdf83f31251e0668b42784813801579641b29410b3c7998d6bc465745e5c392669d6870da2c082a939e37fdcb82ec93edac97ff3ad5950accfbc111c76f1a9529444e56aaf68c56c092cd38dc3bef5d20a939926ed4f74a13eddfbe1a1cecc4894af9428c2b7b8883fe4463a4bc85b1cb3c1", 16);
        String string = "12 53 e0 4d c0 a5 39 7b b4 4a 7a b8 7e 9b f2 a0 39 a3 3d 1e 99 6f c8 2a 94 cc d3 00 74 c9 5d f7 63 72 20 17 06 9e 52 68 da 5d 1c 0b 4f 87 2c f6 53 c1 1d f8 23 14 a6 79 68 df ea e2 8d ef 04 bb 6d 84 b1 c3 1d 65 4a 19 70 e5 78 3b d6 eb 96 a0 24 c2 ca 2f 4a 90 fe 9f 2e f5 c9 c1 40 e5 bb 48 da 95 36 ad 87 00 c8 4f c9 13 0a de a7 4e 55 8d 51 a7 4d df 85 d8 b5 0d e9 68 38 d6 06 3e 09 55 ";
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        PrivateKey privateKey = keyFactory.generatePrivate(rSAPrivateKeySpec);
        oAEPCipher.init(2, privateKey, new SecureRandom());
        byte[] byArray2 = HexDump.hexStringToByteArray(string);
        byte[] byArray3 = oAEPCipher.processBlock(byArray2, 0, byArray2.length);
        System.out.println(HexDump.byteArrayToHexString(byArray3));
    }
}

