/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.helper.NSAttrCompare;
import org.apache.xml.security.c14n.helper.NonNSAttrCompare;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class Canonicalizer20010315
extends CanonicalizerSpi {
    boolean _includeComments = false;
    Set _xpathNodeSet = null;
    Document _doc = null;
    Element _documentElement = null;
    Node _rootNodeOfC14n = null;
    Writer _writer = null;
    private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;

    public Canonicalizer20010315(boolean bl) {
        this._includeComments = bl;
    }

    public byte[] engineCanonicalizeSubTree(Node node) throws CanonicalizationException {
        this._rootNodeOfC14n = node;
        this._doc = XMLUtils.getOwnerDocument(this._rootNodeOfC14n);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                HashMap hashMap = node.getNodeType() == 1 ? Canonicalizer20010315.getinscopeNamespaces((Element)node) : new HashMap();
                HashMap hashMap2 = new HashMap();
                this.canonicalizeSubTree(node, hashMap, hashMap2);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var7_8 = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeSubTree(Node node, Map map, Map map2) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.canonicalizeSubTree(node2, map, map2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                int n = Canonicalizer20010315.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                int n = Canonicalizer20010315.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                this.outputTextToWriter(node.getNodeValue());
                break;
            }
            case 1: {
                Element element = (Element)node;
                this._writer.write("<");
                this._writer.write(element.getTagName());
                List list = this.updateinscopeNamespacesAndReturnVisibleAttrs(element, map, map2);
                int n = 0;
                while (n < list.size()) {
                    this.outputAttrToWriter(((Attr)list.get(n)).getNodeName(), ((Attr)list.get(n)).getNodeValue());
                    ++n;
                }
                this._writer.write(">");
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    if (node3.getNodeType() == 1) {
                        this.canonicalizeSubTree(node3, new HashMap(map), new HashMap(map2));
                    } else {
                        this.canonicalizeSubTree(node3, map, map2);
                    }
                    node3 = node3.getNextSibling();
                }
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    List updateinscopeNamespacesAndReturnVisibleAttrs(Element element, Map map, Map map2) throws CanonicalizationException {
        String string;
        Object object;
        Attr attr;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            attr = (Attr)namedNodeMap.item(n2);
            object = attr.getNodeName();
            string = attr.getValue();
            if (((String)object).equals("xmlns") && string.equals("")) {
                map.remove("xmlns");
            } else if (((String)object).startsWith("xmlns")) {
                if (!string.equals("")) {
                    map.put(object, string);
                }
            } else if (((String)object).startsWith("xml:")) {
                map.put(object, string);
            } else {
                vector2.add(attr);
            }
            ++n2;
        }
        if (map2.containsKey("xmlns") && !map.containsKey("xmlns")) {
            map2.remove("xmlns");
            attr = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            attr.setValue("");
            vector.add(attr);
        }
        boolean bl = element == this._rootNodeOfC14n;
        object = map.keySet().iterator();
        while (object.hasNext()) {
            Object[] objectArray;
            string = (String)object.next();
            String string2 = (String)map.get(string);
            if (string.startsWith("xml:") && (bl || !map2.containsKey(string) || !map2.get(string).equals(string2))) {
                map2.put(string, string2);
                objectArray = this._doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", string);
                objectArray.setValue(string2);
                vector2.add(objectArray);
                continue;
            }
            if (map2.containsKey(string) && (!map2.containsKey(string) || map2.get(string).equals(string2))) continue;
            if (C14nHelper.namespaceIsRelative(string2)) {
                objectArray = new Object[]{element.getTagName(), string, string2};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
            map2.put(string, string2);
            objectArray = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", string);
            objectArray.setValue(string2);
            vector.add(objectArray);
        }
        Collections.sort(vector, new NSAttrCompare());
        Collections.sort(vector2, new NonNSAttrCompare());
        vector.addAll(vector2);
        return vector;
    }

    public static Map getinscopeNamespaces(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Node node = element.getParentNode();
        while (node != null && node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string = attr.getNodeName();
                String string2 = attr.getValue();
                if (!(string.equals("xmlns") && string2.equals("") || !string.startsWith("xml:") && (!string.startsWith("xmlns") || string2.equals("")) || hashMap.containsKey(string))) {
                    hashMap.put(string, string2);
                }
                ++n2;
            }
            node = node.getParentNode();
        }
        return hashMap;
    }

    static int getPositionRelativeToDocumentElement(Node node) {
        if (node == null) {
            return 0;
        }
        Document document = node.getOwnerDocument();
        if (node.getParentNode() != document) {
            return 0;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return 0;
        }
        if (element == node) {
            return 0;
        }
        Node node2 = node;
        while (node2 != null) {
            if (node2 == element) {
                return -1;
            }
            node2 = node2.getNextSibling();
        }
        return 1;
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        Object object;
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        if (this._doc == null) {
            object = (Node)this._xpathNodeSet.iterator().next();
            this._doc = XMLUtils.getOwnerDocument((Node)object);
            this._documentElement = this._doc.getDocumentElement();
        }
        try {
            try {
                object = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)object, "UTF8");
                this.canonicalizeXPathNodeSet(this._doc, true, new C14nCtx());
                this._writer.close();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                Object var5_6 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeXPathNodeSet(Node node, boolean bl, C14nCtx c14nCtx) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        boolean bl2 = this._xpathNodeSet.contains(node);
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.canonicalizeXPathNodeSet(node2, bl2, c14nCtx);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments || !bl2) break;
                int n = Canonicalizer20010315.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                if (!bl2) break;
                int n = Canonicalizer20010315.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                if (!bl2) break;
                this.outputTextToWriter(node.getNodeValue());
                Node node3 = node.getNextSibling();
                while (node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4)) {
                    this.outputTextToWriter(node3.getNodeValue());
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 1: {
                Node node4;
                Element element = (Element)node;
                if (bl2) {
                    this._writer.write("<");
                    this._writer.write(element.getTagName());
                }
                List list = this.getAttrs(element, bl, c14nCtx);
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    node4 = (Attr)list.get(n2);
                    this.outputAttrToWriter(node4.getNodeName(), node4.getNodeValue());
                    ++n2;
                }
                if (bl2) {
                    this._writer.write(">");
                }
                node4 = node.getFirstChild();
                while (node4 != null) {
                    if (node4.getNodeType() == 1) {
                        this.canonicalizeXPathNodeSet(node4, bl2, c14nCtx.copy());
                    } else {
                        this.canonicalizeXPathNodeSet(node4, bl2, c14nCtx);
                    }
                    node4 = node4.getNextSibling();
                }
                if (!bl2) break;
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    List getAttrs(Element element, boolean bl, C14nCtx c14nCtx) throws CanonicalizationException {
        Object object;
        Object object2;
        boolean bl2 = this._xpathNodeSet.contains(element);
        Vector<Attr> vector = new Vector<Attr>();
        Vector<Attr> vector2 = new Vector<Attr>();
        Vector<Attr> vector3 = new Vector<Attr>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            object2 = attr.getNamespaceURI();
            if (this._xpathNodeSet.contains(attr)) {
                if (object2 != null) {
                    if ("http://www.w3.org/2000/xmlns/".equals(object2)) {
                        object = attr.getValue();
                        if (C14nHelper.namespaceIsRelative((String)object)) {
                            Object[] objectArray = new Object[]{element.getTagName(), attr.getNodeName(), object};
                            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
                        }
                        vector.add(attr);
                    } else if ("http://www.w3.org/XML/1998/namespace".equals(object2)) {
                        vector3.add(attr);
                        c14nCtx.a.put(attr.getNodeName(), attr);
                    } else {
                        vector2.add(attr);
                    }
                } else {
                    vector2.add(attr);
                }
            } else if (object2 != null && "http://www.w3.org/XML/1998/namespace".equals(object2)) {
                c14nCtx.a.put(attr.getNodeName(), attr);
            }
            ++n2;
        }
        Collections.sort(vector, new NSAttrCompare());
        int n3 = 0;
        while (n3 < vector3.size()) {
            object2 = (Attr)vector3.get(n3);
            object = object2.getNodeName();
            c14nCtx.a.put(object, object2);
            ++n3;
        }
        if (bl2 && !bl) {
            object2 = c14nCtx.a.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                vector2.add((Attr)c14nCtx.a.get(object));
            }
        }
        Collections.sort(vector2, new NonNSAttrCompare());
        object2 = new Vector();
        object = new HashMap();
        if (vector.size() > 0) {
            int n4 = -1;
            Attr attr = (Attr)vector.get(0);
            if (!attr.getNodeName().equals("xmlns")) {
                n4 = 0;
                if (bl2 && c14nCtx.n.containsKey("xmlns") && !c14nCtx.n.get("xmlns").equals("")) {
                    Attr attr2 = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                    attr2.setValue("");
                    ((Vector)object2).add(attr2);
                }
            } else if (attr.getNodeName().equals("xmlns") && attr.getValue().equals("")) {
                n4 = 1;
                if (bl2 && c14nCtx.n.containsKey("xmlns") && !c14nCtx.n.get("xmlns").equals("")) {
                    ((Vector)object2).add(attr);
                }
            } else {
                n4 = 0;
            }
            int n5 = n4;
            while (n5 < vector.size()) {
                Attr attr3 = (Attr)vector.get(n5);
                String string = attr3.getNodeName();
                object.put(string, attr3);
                if (!c14nCtx.n.containsKey(string) || !((Attr)c14nCtx.n.get(string)).getValue().equals(attr3.getValue())) {
                    ((Vector)object2).add(attr3);
                }
                ++n5;
            }
        }
        if (bl2) {
            c14nCtx.n = object;
        }
        ((Vector)object2).addAll(vector2);
        return object2;
    }

    void outputAttrToWriter(String string, String string2) throws IOException {
        this._writer.write(" ");
        this._writer.write(string);
        this._writer.write("=\"");
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '\"': {
                    this._writer.write("&quot;");
                    break;
                }
                case '\t': {
                    this._writer.write("&#x9;");
                    break;
                }
                case '\n': {
                    this._writer.write("&#xA;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        this._writer.write("\"");
    }

    void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        if (processingInstruction == null) {
            return;
        }
        this._writer.write("<?");
        String string = processingInstruction.getTarget();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        String string2 = processingInstruction.getData();
        n = string2.length();
        if (string2 != null && n > 0) {
            this._writer.write(" ");
            int n3 = 0;
            while (n3 < n) {
                char c = string2.charAt(n3);
                switch (c) {
                    case '\r': {
                        this._writer.write("&#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++n3;
            }
        }
        this._writer.write("?>");
    }

    void outputCommentToWriter(Comment comment) throws IOException {
        if (comment == null) {
            return;
        }
        this._writer.write("<!--");
        String string = comment.getData();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        this._writer.write("-->");
    }

    void outputTextToWriter(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '>': {
                    this._writer.write("&gt;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    class C14nCtx {
        Map a;
        Map n;

        public C14nCtx() {
            this.a = new HashMap();
            this.n = new HashMap();
        }

        public C14nCtx(Map map, Map map2) {
            this.a = map;
            this.n = map2;
        }

        public C14nCtx copy() {
            C14nCtx c14nCtx = new C14nCtx();
            c14nCtx.a = new HashMap(this.a);
            c14nCtx.n = new HashMap(this.n);
            return c14nCtx;
        }
    }
}

