/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sun.security.util.DerValue;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$keys$content$x509$XMLX509SKI == null ? (class$org$apache$xml$security$keys$content$x509$XMLX509SKI = XMLX509SKI.class$("org.apache.xml.security.keys.content.x509.XMLX509SKI")) : class$org$apache$xml$security$keys$content$x509$XMLX509SKI).getName());
    public static final String SKI_OID = "2.5.29.14";
    static /* synthetic */ Class class$org$apache$xml$security$keys$content$x509$XMLX509SKI;

    public XMLX509SKI(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509SKI(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509Certificate));
    }

    public XMLX509SKI(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate x509Certificate) throws XMLSecurityException {
        try {
            byte[] byArray = x509Certificate.getExtensionValue(SKI_OID);
            if (x509Certificate.getVersion() < 3) {
                Object[] objectArray = new Object[]{new Integer(x509Certificate.getVersion())};
                throw new XMLSecurityException("certificate.noSki.lowVersion", objectArray);
            }
            DerValue derValue = new DerValue(byArray);
            if (derValue == null) {
                throw new XMLSecurityException("certificate.noSki.null");
            }
            if (derValue.tag != 4) {
                throw new XMLSecurityException("certificate.noSki.notOctetString");
            }
            byte[] byArray2 = derValue.getOctetString();
            byte[] byArray3 = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray3, 0, byArray3.length);
            cat.debug((Object)("Base64 of SKI is " + Base64.encode(byArray3)));
            return byArray3;
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    private void createSKIElementFromCert(X509Certificate x509Certificate) throws XMLSecurityException {
        byte[] byArray = XMLX509SKI.getSKIBytesFromCert(x509Certificate);
        Base64.encodeToElement(this._doc, "X509SKI", byArray);
    }

    public boolean equals(Object object) {
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SKI xMLX509SKI = (XMLX509SKI)object;
        try {
            return JavaUtils.binaryCompare(xMLX509SKI.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509SKI";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

