/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver = RetrievalMethodResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.RetrievalMethodResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver).getName());
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "RetrievalMethod");
        }
        catch (XMLSignatureException xMLSignatureException) {
            return false;
        }
        return true;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            Attr attr = retrievalMethod.getURIAttr();
            String string2 = retrievalMethod.getType();
            Transforms transforms = retrievalMethod.getTransforms();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
            if (resourceResolver != null) {
                XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                cat.debug((Object)("Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes"));
                if (transforms != null) {
                    cat.debug((Object)"We have Transforms");
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                cat.debug((Object)("After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes"));
                cat.debug((Object)("Resolved to resource " + xMLSignatureInput.getSourceURI()));
                byte[] byArray = xMLSignatureInput.getBytes();
                if (string2 != null && string2.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    if (x509Certificate != null) {
                        return x509Certificate.getPublicKey();
                    }
                } else {
                    KeyResolver keyResolver;
                    cat.debug((Object)("we have to parse " + byArray.length + " bytes"));
                    Element element2 = this.getDocFromBytes(byArray);
                    cat.debug((Object)("Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element"));
                    if (element2 != null && (keyResolver = KeyResolver.getInstance(element2, string, storageResolver)) != null) {
                        return keyResolver.resolvePublicKey(element2, string, storageResolver);
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            cat.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            cat.debug((Object)"CertificateException", (Throwable)certificateException);
        }
        catch (IOException iOException) {
            cat.debug((Object)"IOException", (Throwable)iOException);
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            Attr attr = retrievalMethod.getURIAttr();
            String string2 = retrievalMethod.getType();
            Transforms transforms = retrievalMethod.getTransforms();
            cat.debug((Object)("Asked to resolve URI " + attr));
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
            if (resourceResolver != null) {
                XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                cat.debug((Object)("Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes"));
                if (transforms != null) {
                    cat.debug((Object)"We have Transforms");
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                cat.debug((Object)("After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes"));
                cat.debug((Object)("Resolved to resource " + xMLSignatureInput.getSourceURI()));
                byte[] byArray = xMLSignatureInput.getBytes();
                if (retrievalMethod.getType() != null && retrievalMethod.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    if (x509Certificate != null) {
                        return x509Certificate;
                    }
                } else {
                    KeyResolver keyResolver;
                    cat.debug((Object)("we have to parse " + byArray.length + " bytes"));
                    Element element2 = this.getDocFromBytes(byArray);
                    cat.debug((Object)("Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element"));
                    if (element2 != null && (keyResolver = KeyResolver.getInstance(element2, string, storageResolver)) != null) {
                        return keyResolver.resolveX509Certificate(element2, string, storageResolver);
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            cat.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            cat.debug((Object)"CertificateException", (Throwable)certificateException);
        }
        catch (IOException iOException) {
            cat.debug((Object)"IOException", (Throwable)iOException);
        }
        return null;
    }

    Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

