/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.provider.KeyStoreElement;
import org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ApacheKeyStore
extends KeyStoreSpi {
    private static final boolean PERMIT_EMPTY_STORE_PASSWORDS = true;
    private static final boolean PERMIT_STORE_WITHOUT_SIGNATURE = true;
    KeyStoreElement _keyStoreElement;

    public ApacheKeyStore() {
        try {
            ElementProxy.setDefaultPrefix("http://xml.apache.org/security/#KeyStore", "ks");
        }
        catch (XMLSecurityException xMLSecurityException) {
            // empty catch block
        }
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (inputStream == null) {
                Document document = documentBuilder.newDocument();
                this._keyStoreElement = new KeyStoreElement(document);
                document.appendChild(this._keyStoreElement.getElement());
            } else {
                boolean bl;
                Document document = documentBuilder.parse(inputStream);
                this._keyStoreElement = new KeyStoreElement(document.getDocumentElement(), "memory://");
                if (cArray != null && !(bl = this._keyStoreElement.verify(cArray))) {
                    throw new IOException("The integrity of the KeyStore is broken; maybe someone messed around in the KeyStore");
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new IOException(xMLSecurityException.getMessage());
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            if (cArray != null) {
                this._keyStoreElement.sign(cArray);
            } else {
                this._keyStoreElement.removeOldSignatures();
            }
            Canonicalizer canonicalizer = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            outputStream.write(canonicalizer.canonicalizeSubtree(this._keyStoreElement.getDocument()));
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new IOException(invalidCanonicalizerException.getMessage());
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new IOException(canonicalizationException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean engineContainsAlias(String var1_1) {
        if (var1_1 == null) {
            return false;
        }
        var2_2 = this.engineAliases();
        if (var2_2 != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = (String)var2_2.nextElement();
            if (!var3_3.equals(var1_1)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl10:
        // 1 sources

        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string) || !certificate.equals(certificate2 = this.engineGetCertificate(string))) continue;
            return string;
        }
        return null;
    }

    public int engineSize() {
        return this._keyStoreElement.getNumberOfKeys() + this._keyStoreElement.getNumberOfCertificates();
    }

    public Enumeration engineAliases() {
        return this._keyStoreElement.aliases();
    }

    public Date engineGetCreationDate(String string) {
        return this._keyStoreElement.getCreationDate(string);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        this._keyStoreElement.deleteEntry(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this._keyStoreElement.isCertificateEntry(string);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this._keyStoreElement.setCertificateEntry(string, certificate);
    }

    public Certificate engineGetCertificate(String string) {
        return this._keyStoreElement.getCertificate(string);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        return this._keyStoreElement.getCertificateChain(string);
    }

    public boolean engineIsKeyEntry(String string) {
        return this._keyStoreElement.isCertificateEntry(string);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this._keyStoreElement.setKeyEntry(string, byArray, certificateArray);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this._keyStoreElement.setKeyEntry(string, key, cArray, certificateArray);
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this._keyStoreElement.getKey(string, cArray);
    }
}

