/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.utils.StringValueTable;

public final class Opcode {
    private static StringValueTable opcodes = new StringValueTable();
    public static final byte QUERY = 0;
    public static final byte IQUERY = 1;
    public static final byte STATUS = 2;
    public static final byte NOTIFY = 4;
    public static final byte UPDATE = 5;

    private Opcode() {
    }

    public static String string(int i) {
        String s = opcodes.getString(i);
        return s != null ? s : new Integer(i).toString();
    }

    public static byte value(String s) {
        byte i = (byte)opcodes.getValue(s.toUpperCase());
        if (i >= 0) {
            return i;
        }
        try {
            return Byte.parseByte(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        opcodes.put2(0, "QUERY");
        opcodes.put2(0, "IQUERY");
        opcodes.put2(0, "STATUS");
        opcodes.put2(4, "NOTIFY");
        opcodes.put2(5, "UPDATE");
    }
}

