/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.client;

import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis.client.Stub;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.lsid.stub.IdentifierServiceLocator;
import org.ecoinformatics.ecogrid.lsid.stub.IdentifierServicePortType;

public class IdentifierServiceClient {
    IdentifierServicePortType ecogrid;
    private String serviceURL = null;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java org.ecoinformatics.ecogrid.client.IdentifierServiceClient url <lsid> action");
            System.out.println("  Where action is either 'add', 'isRegistered', 'nextRev', 'nextObj', or getallids");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        System.out.println("lsid is: " + string2);
        System.out.println("url is: " + string);
        System.out.println("action: " + string3);
        try {
            IdentifierServiceClient identifierServiceClient = new IdentifierServiceClient(string);
            if (string3.equals("isRegistered")) {
                boolean bl = identifierServiceClient.isRegistered(string2);
                System.out.println("answer is " + bl);
            } else if (string3.equals("add")) {
                String string4 = identifierServiceClient.addLSID(string2);
                System.out.println("answer is " + string4);
            } else if (string3.equals("nextRev")) {
                String string5 = identifierServiceClient.getNextRevision(string2);
                System.out.println("answer is " + string5);
            } else if (string3.equals("nextObj")) {
                String string6 = identifierServiceClient.getNextObject(string2);
                System.out.println("answer is " + string6);
            } else if (string3.equals("getallids")) {
                String string7 = identifierServiceClient.getAllIds(string2);
                System.out.println("answer is " + string7);
            } else {
                System.out.println("Incorrect action " + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public IdentifierServiceClient(String string) throws Exception {
        this.serviceURL = string;
        long l = System.currentTimeMillis();
        IdentifierServiceLocator identifierServiceLocator = new IdentifierServiceLocator();
        this.ecogrid = identifierServiceLocator.getIdentifier(new URL(this.serviceURL));
        Stub stub = (Stub)this.ecogrid;
        stub.setTimeout(10000000);
        long l2 = System.currentTimeMillis();
        EcogridUtils.debugMessage("The time to create instance is =========== " + (l2 - l) / 1000L, 30);
    }

    public boolean isRegistered(String string) throws RemoteException {
        return new Boolean(this.ecogrid.isRegistered(string));
    }

    public String getNextRevision(String string) throws RemoteException {
        return this.ecogrid.getNextRevision(string);
    }

    public String getNextObject(String string) throws RemoteException {
        return this.ecogrid.getNextObject(string);
    }

    public String addLSID(String string) throws RemoteException {
        return this.ecogrid.addLSID(string);
    }

    public String getAllIds(String string) throws RemoteException {
        return this.ecogrid.getAllIds(string);
    }
}

