/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.ServicePropertiesHelper;
import org.gridforum.ogsi.EntryContentType;
import org.gridforum.ogsi.EntryType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.LocatorType;

public class ServiceGroupEntryGenerator {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$ServiceGroupEntryGenerator == null ? (class$org$globus$ogsa$ServiceGroupEntryGenerator = ServiceGroupEntryGenerator.class$("org.globus.ogsa.ServiceGroupEntryGenerator")) : class$org$globus$ogsa$ServiceGroupEntryGenerator).getName());
    static /* synthetic */ Class class$org$globus$ogsa$ServiceGroupEntryGenerator;

    public static Collection nodeToEntries(ServiceNode node) {
        Vector services = node.getAllServices();
        return ServiceGroupEntryGenerator.servicesToEntries(services);
    }

    public static Collection servicesToEntries(Collection services) {
        ArrayList<EntryType> list = new ArrayList<EntryType>();
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            ServiceProperties properties = (ServiceProperties)iterator.next();
            list.add(ServiceGroupEntryGenerator.createEntry(properties));
        }
        return list;
    }

    public static Collection handlesToEntries(Iterator handles) {
        ArrayList<EntryType> list = new ArrayList<EntryType>();
        while (handles.hasNext()) {
            String handle = (String)handles.next();
            list.add(ServiceGroupEntryGenerator.createEntry(handle));
        }
        return list;
    }

    private static EntryType createEntry(String handle) {
        EntryType entry = new EntryType();
        LocatorType locator = new LocatorType();
        locator.setHandle(new HandleType[]{new HandleType(handle)});
        entry.setMemberServiceLocator(locator);
        return entry;
    }

    private static EntryType createEntry(ServiceProperties properties) {
        String handle = (String)properties.getProperty("Handle");
        EntryType entry = new EntryType();
        LocatorType locator = new LocatorType();
        locator.setHandle(new HandleType[]{new HandleType(handle)});
        entry.setMemberServiceLocator(locator);
        try {
            ExtensibilityType extension = ServicePropertiesHelper.getAsAny(properties);
            EntryContentType content = new EntryContentType();
            content.set_any(extension.get_any());
            entry.setContent(content);
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("propertiesDetailsError", new String[]{MessageUtils.toString(e)}));
        }
        return entry;
    }

    public static void updateServiceData(Collection services, GridServiceBase base) throws GridServiceException {
        ServiceGroupEntryGenerator.updateServiceDataEntries(ServiceGroupEntryGenerator.servicesToEntries(services), base);
    }

    public static void updateServiceData(Iterator handles, GridServiceBase base) throws GridServiceException {
        ServiceGroupEntryGenerator.updateServiceDataEntries(ServiceGroupEntryGenerator.handlesToEntries(handles), base);
    }

    public static void updateServiceDataEntries(Collection entries, GridServiceBase base) throws GridServiceException {
        ServiceDataSet serviceDataSet = base.getServiceDataSet();
        ServiceData serviceData = serviceDataSet.create(ServiceData.ENTRY);
        serviceData.setValues(entries);
        serviceDataSet.add(serviceData);
        serviceData.notifyChange();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

