/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.WSDLException;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.wsdl.GSRDescription;
import org.globus.ogsa.wsdl.SymbolTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLGenerator {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$WSDLGenerator == null ? (class$org$globus$ogsa$WSDLGenerator = WSDLGenerator.class$("org.globus.ogsa.WSDLGenerator")) : class$org$globus$ogsa$WSDLGenerator).getName());
    static Hashtable cachedServices = new Hashtable();
    static Hashtable cachedDescriptions = new Hashtable();
    static /* synthetic */ Class class$org$globus$ogsa$WSDLGenerator;

    public static void getWSDL(ServiceProperties properties) throws GridServiceException {
        String schemaPath = (String)properties.getProperty("schemaPath");
        String servicePath = (String)properties.getProperty("servicePath");
        WSDLGenerator.getWSDL(schemaPath, servicePath, properties);
    }

    public static void getInstanceWSDL(GridServiceBase properties) throws GridServiceException {
        WSDLGenerator.getWSDL((String)properties.getInstanceProperty("schemaPath"), "instance", properties, true);
    }

    public static void getWSDL(String wsdlPath, String servicePath, ServiceProperties properties) throws GridServiceException {
        WSDLGenerator.getWSDL(wsdlPath, servicePath, properties, false);
    }

    private static void getWSDL(String wsdlPath, String servicePath, ServiceProperties properties, boolean instanceGeneration) throws GridServiceException {
        Document doc;
        NodeList nodes;
        String schemaRoot;
        String protocol;
        if (wsdlPath == null) {
            throw new ConfigException(MessageUtils.getMessage("schemaPathNotFound"));
        }
        if (servicePath == null) {
            throw new ConfigException(MessageUtils.getMessage("servicePathNotFound"));
        }
        ContainerConfig config = ContainerConfig.getConfig();
        String host = ServiceHost.getHost();
        String port = (String)properties.getProperty("port");
        if (port == null) {
            port = "8080";
        }
        if ((protocol = (String)properties.getProperty("protocol")) == null) {
            protocol = "http";
        }
        if ((schemaRoot = System.getProperty("org.globus.ogsa.schema.root")) != null && schemaRoot.equals("")) {
            schemaRoot = null;
        }
        if (schemaRoot == null) {
            schemaRoot = config.getOption("schemaRoot");
        }
        if (schemaRoot == null) {
            String schemaContext = config.getOption("schemaContext");
            schemaContext = schemaContext == null ? "" : schemaContext + "/";
            schemaRoot = protocol + "://" + host + ":" + port + "/" + schemaContext;
        }
        if ((nodes = (doc = WSDLGenerator.getServiceWSDL(schemaRoot + wsdlPath, properties)).getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address")).getLength() == 0) {
            throw new WSDLException(MessageUtils.getMessage("noSOAPAddressError"));
        }
        String url = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Element address = (Element)nodes.item(i);
            String endpointTemplate = address.getAttribute("location");
            URL endpointURL = null;
            try {
                endpointURL = new URL(endpointTemplate);
            }
            catch (Exception e) {
                throw new GridServiceException(endpointTemplate, e);
            }
            String templateProtocol = endpointURL.getProtocol();
            String templatePort = config.getOption(templateProtocol + "Port");
            if (templatePort == null) {
                if (templateProtocol.equalsIgnoreCase(protocol)) {
                    templatePort = port;
                } else {
                    throw new ConfigException(MessageUtils.getMessage("noPortConfig", new String[]{"" + templateProtocol}));
                }
            }
            url = templateProtocol + "://" + host + ":" + templatePort + "/" + config.getLocalOgsiLocation() + servicePath;
            address.setAttribute("location", url);
            ++i;
        }
        String targetNamespace = doc.getDocumentElement().getAttribute("targetNamespace");
        QName serviceName = WSDLGenerator.addHandle(doc, url, properties, instanceGeneration, targetNamespace);
        if (instanceGeneration) {
            properties.setProperty("instance-WSDL", doc);
            properties.setProperty("instance-portType", serviceName.getLocalPart());
            properties.setProperty("instance-portTypeNS", serviceName.getNamespaceURI());
            WSDLGenerator.getSymbolTable(doc, properties, instanceGeneration, serviceName);
        } else {
            properties.setProperty("WSDL", doc);
            properties.setProperty("portType", serviceName.getLocalPart());
            properties.setProperty("portTypeNS", serviceName.getNamespaceURI());
            properties.setProperty("Endpoint", url);
            WSDLGenerator.getSymbolTable(doc, properties, instanceGeneration, serviceName);
        }
    }

    public static void clearCache(ServiceProperties properties) {
        String schemaLocation = (String)properties.getProperty("schemaLocation");
        if (schemaLocation != null) {
            cachedServices.remove(schemaLocation);
        }
        String servicePortTypeNS = (String)properties.getProperty("portTypeNS");
        String servicePortType = (String)properties.getProperty("portType");
        if (servicePortType != null) {
            cachedDescriptions.remove(new QName(servicePortTypeNS, servicePortType));
        }
    }

    private static QName addHandle(Document doc, String url, ServiceProperties properties, boolean instanceGeneration, String targetNamespace) throws GridServiceException {
        QName serviceName = null;
        URL handleURL = null;
        try {
            handleURL = new URL(url);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        String handle = HandleHelper.getHandle(handleURL.getPath(), properties);
        NodeList nodes = doc.getElementsByTagNameNS("http://ogsa.globus.org/", "instanceOf");
        Element instanceOfElement = null;
        NodeList services = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
        if (services.getLength() != 1) {
            throw new WSDLException(MessageUtils.getMessage("serviceElementError"));
        }
        Element serviceElement = (Element)services.item(0);
        serviceName = new QName(targetNamespace, serviceElement.getAttribute("name"));
        if (nodes.getLength() == 0) {
            serviceElement.setAttribute("xmlns:gsdl", "http://ogsa.globus.org/");
            instanceOfElement = doc.createElement("gsdl:instanceOf");
            Node firstChild = serviceElement.getFirstChild();
            serviceElement.insertBefore(instanceOfElement, firstChild);
        } else {
            instanceOfElement = (Element)nodes.item(0);
        }
        String servicePortTypeName = instanceOfElement.getAttribute("type");
        if (servicePortTypeName != null && !servicePortTypeName.equals("")) {
            serviceName = XMLUtils.getQNameFromString((String)servicePortTypeName, (Node)instanceOfElement);
        }
        instanceOfElement.setAttribute("handle", handle);
        if (!instanceGeneration) {
            properties.setProperty("Handle", handle);
        }
        return serviceName;
    }

    private static Document getServiceWSDL(String wsdlURL, ServiceProperties properties) throws GridServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading WSDL from: " + wsdlURL));
        }
        properties.setProperty("schemaLocation", wsdlURL);
        Document doc = (Document)cachedServices.get(wsdlURL);
        if (doc != null) {
            return (Document)doc.cloneNode(true);
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(wsdlURL);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        NodeList nodes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        int i = 0;
        while (i < nodes.getLength()) {
            Element importElement = (Element)nodes.item(i);
            String location = importElement.getAttribute("location");
            if (location == null) {
                throw new WSDLException(MessageUtils.getMessage("noSOAPLocationError"));
            }
            if (location.indexOf("://") == -1) {
                String wsdlDir = wsdlURL.substring(0, wsdlURL.lastIndexOf("/"));
                int subPath = location.indexOf("../");
                while (subPath != -1) {
                    location = location.substring(subPath + 3);
                    wsdlDir = wsdlDir.substring(0, wsdlDir.lastIndexOf("/"));
                    subPath = location.indexOf("../");
                }
                importElement.removeAttribute("location");
                importElement.setAttribute("location", wsdlDir + "/" + location);
            }
            ++i;
        }
        cachedServices.put(wsdlURL, doc);
        return doc;
    }

    public static void getPortTypes(Definition wsdlDefinition, Vector portTypes) {
        if (wsdlDefinition == null) {
            return;
        }
        Iterator imports = wsdlDefinition.getImports().values().iterator();
        while (imports.hasNext()) {
            Vector importedObjects = (Vector)imports.next();
            Enumeration importedDefinitions = importedObjects.elements();
            while (importedDefinitions.hasMoreElements()) {
                Import importedDefinition = (Import)importedDefinitions.nextElement();
                WSDLGenerator.getPortTypes(importedDefinition.getDefinition(), portTypes);
            }
        }
        Map portTypesMap = wsdlDefinition.getPortTypes();
        Iterator iter = portTypesMap.keySet().iterator();
        while (iter.hasNext()) {
            QName name = (QName)iter.next();
            portTypes.addElement(name);
        }
    }

    private static void getSymbolTable(Document doc, ServiceProperties properties, boolean instanceGeneration, QName serviceName) throws GridServiceException {
        GSRDescription description = (GSRDescription)cachedDescriptions.get(serviceName);
        if (description == null) {
            description = (GSRDescription)properties.getProperty("instance-GSRDescription");
        }
        if (description == null) {
            SymbolTable symbolTable = new SymbolTable();
            description = symbolTable.add(doc);
            cachedDescriptions.put(serviceName, description);
        }
        if (instanceGeneration) {
            properties.setProperty("instance-GSRDescription", description);
        } else {
            properties.setProperty("GSRDescription", description);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

