/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBHome;
import org.globus.ogsa.utils.GridServiceFactory;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.OGSIServiceGridLocator;

public class EJBServiceClient {
    private static Map remoteUrlMap = new HashMap();
    static /* synthetic */ Class class$java$net$URL;

    public static EJBHome createHomeService(String homeClassName, String remoteClassName, String urlString) throws RemoteException {
        try {
            EJBServiceClient.createService(urlString);
            return EJBServiceClient.lookupHomeService(homeClassName, remoteClassName, urlString);
        }
        catch (FaultType fault) {
            throw fault;
        }
        catch (Exception e) {
            throw new RemoteException("Can't create home service: " + urlString, e);
        }
    }

    public static EJBHome lookupHomeService(String homeClassName, String remoteClassName, String urlString) throws RemoteException {
        try {
            Object homePortType = EJBServiceClient.locateService(homeClassName, "getHome", urlString);
            Class<?> homeInterface = Class.forName(homeClassName);
            HomeWrapper wrapper = new HomeWrapper(homePortType, remoteClassName);
            Object proxy = Proxy.newProxyInstance(homeInterface.getClassLoader(), new Class[]{homeInterface}, (InvocationHandler)wrapper);
            return (EJBHome)proxy;
        }
        catch (Exception e) {
            throw new RemoteException("Can't look up home service: " + urlString, e);
        }
    }

    public static String getRemoteUrl(Object remote) {
        return (String)remoteUrlMap.get(remote);
    }

    private static Object locateService(String className, String locatorMethodName, String urlString) throws Exception {
        Class<?> locatorClass = Class.forName(className + "ServiceLocator");
        Method locatorMethod = locatorClass.getMethod(locatorMethodName, class$java$net$URL == null ? (class$java$net$URL = EJBServiceClient.class$("java.net.URL")) : class$java$net$URL);
        Object locator = locatorClass.newInstance();
        URL url = new URL(urlString);
        return locatorMethod.invoke(locator, url);
    }

    public static void createService(String urlString) throws Exception {
        if (urlString.endsWith("/")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        int slashPos = urlString.lastIndexOf(47);
        String path = urlString.substring(slashPos + 1);
        urlString = urlString.substring(0, slashPos);
        OGSIServiceGridLocator factoryService = new OGSIServiceGridLocator();
        GridServiceFactory factory = new GridServiceFactory(factoryService.getFactoryPort(new URL(urlString)));
        factory.createService(null, path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HomeWrapper
    implements InvocationHandler {
        Object homeService;
        String remoteClassName;

        public HomeWrapper(Object _homeService, String _remoteClassName) {
            this.homeService = _homeService;
            this.remoteClassName = _remoteClassName;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method serviceMethod = this.homeService.getClass().getMethod(method.getName(), method.getParameterTypes());
            String remoteUrl = (String)serviceMethod.invoke(this.homeService, args);
            System.out.println("created remote service: " + remoteUrl);
            Object remote = EJBServiceClient.locateService(this.remoteClassName, "getRemote", remoteUrl);
            remoteUrlMap.put(remote, remoteUrl);
            return remote;
        }
    }
}

