/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import java.net.URL;
import org.globus.ogsa.core.notification.JMSAdapterPortType;
import org.globus.ogsa.core.notification.service.JMSAdapterServiceLocator;

public class JMSAdapterClient {
    public static void printUsage() {
        System.out.println("USAGE: JMSAdapterClient serviceUrl command ... [params] ");
        System.out.println("Commands are:");
        System.out.println(" start  jmsTopicFactoryName");
        System.out.println(" jmsToOgsa  jmsTopicName ogsaTopicName [jmsToOgsaConverterClassName]");
        System.out.println(" ogsaToJMS  ogsaSourceUrlString ogsaTopicName jmsTopicName [ogsaToJMSConverterClassName]");
        System.out.println(" stop");
    }

    public static void main(String[] args) {
        block9: {
            try {
                if (args.length < 1 || args.length > 6) {
                    JMSAdapterClient.printUsage();
                    return;
                }
                String urlString = args[0];
                String command = args[1];
                JMSAdapterServiceLocator locator = new JMSAdapterServiceLocator();
                JMSAdapterPortType jmsAdapter = locator.getJMSAdapterPort(new URL(urlString));
                System.out.println("located JMS Adapter Service");
                if (command.equals("start")) {
                    jmsAdapter.start(args[2]);
                    System.out.println("JMS Adapter Started");
                    break block9;
                }
                if (command.equals("jmsToOgsa")) {
                    String jmsToOgsaConverterClassName = null;
                    if (args.length > 4) {
                        jmsToOgsaConverterClassName = args[4];
                    }
                    jmsAdapter.jmsToOgsa(args[2], args[3], jmsToOgsaConverterClassName);
                    System.out.println("jmsToOgsa topics connected");
                    break block9;
                }
                if (command.equals("ogsaToJMS")) {
                    String ogssaToJMSConverterClassName = null;
                    if (args.length > 5) {
                        ogssaToJMSConverterClassName = args[5];
                    }
                    jmsAdapter.ogsaToJMS(args[2], args[3], args[4], ogssaToJMSConverterClassName);
                    System.out.println("ogsaToJMS topics connected");
                    break block9;
                }
                if (command.equals("stop")) {
                    jmsAdapter.stop();
                    System.out.println("JMS Adapter Stopped");
                    break block9;
                }
                JMSAdapterClient.printUsage();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

