/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.NotificationSink;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NotificationSinkNotifyer {
    private OGSIServiceGridLocator locator = new OGSIServiceGridLocator();
    private NotificationSink sink;

    public NotificationSinkNotifyer(String handle) throws FaultType, GridServiceException {
        HandleType handleType = new HandleType(handle);
        this.sink = this.locator.getNotificationSinkPort(handleType);
    }

    public void notify(String message) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element element = doc.createElement("notification");
        doc.appendChild(element);
        element.setAttribute("message", message);
        ExtensibilityType notification = AnyHelper.getExtensibility(element);
        this.sink.deliverNotification(notification);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("NotificationSinkNotifyer <handle> <message>");
            return;
        }
        try {
            String handle = args[0];
            String message = args[1];
            NotificationSinkNotifyer notifyer = new NotificationSinkNotifyer(handle);
            notifyer.notify(message);
        }
        catch (Exception e) {
            System.err.println(MessageUtils.toString(e));
        }
    }
}

