/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import javax.xml.rpc.Stub;
import org.globus.ogsa.client.ServiceURL;
import org.globus.ogsa.client.ShutdownGetOpts;
import org.globus.ogsa.core.admin.AdminServicePortType;
import org.globus.ogsa.core.admin.service.AdminServiceLocator;
import org.globus.ogsa.utils.MessageUtils;

public class Shutdown {
    public static final String DEFAULT_SERVICE_NAME = "core/admin/AdminService";

    public static void main(String[] args) {
        block8: {
            ShutdownGetOpts opts = new ShutdownGetOpts("Usage: Shutdown [options] [<hard|soft> [service handle]]", 0);
            String error = opts.parse(args);
            if (error != null) {
                System.err.println(error);
                return;
            }
            boolean hardShutdown = false;
            String shutdownArg = opts.getOptionalArg(0);
            if (shutdownArg == null || shutdownArg.equalsIgnoreCase("soft")) {
                hardShutdown = false;
            } else if (shutdownArg.equalsIgnoreCase("hard")) {
                hardShutdown = true;
            } else {
                System.err.println("Error: Invalid shutdown mode. Must be either 'soft' or 'hard'.");
                return;
            }
            AdminServiceLocator locator = new AdminServiceLocator();
            String contactString = opts.getOptionalArg(1);
            try {
                AdminServicePortType admin = locator.getAdminPort(ServiceURL.getURL(contactString, DEFAULT_SERVICE_NAME));
                opts.setOptions((Stub)admin);
                admin.shutdown(hardShutdown);
            }
            catch (Exception e) {
                if (opts.isDebug()) {
                    System.err.println(MessageUtils.toString(e));
                    break block8;
                }
                System.err.println("Error: " + opts.getErrorMessage(e));
            }
        }
    }
}

