/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client.managers;

import java.util.Hashtable;
import java.util.Map;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationSinkCallback;
import org.globus.ogsa.client.managers.NotificationSinkManager;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.ServiceContainer;

public class GSINotificationSinkManager
extends NotificationSinkManager {
    private static final String GSI_CONTAINER_CLASS = "org.globus.ogsa.server.GSIServiceContainer";
    protected ServiceContainer secureContainer;
    protected Map secureContainerProps;

    protected String getWsdl() {
        return "schema/core/notification/gsi_notification_sink_service.wsdl";
    }

    public void init(Map properties) {
        this.properties = properties == null ? new Hashtable() : properties;
        this.secureContainerProps = new Hashtable();
        String prop = null;
        prop = (String)this.properties.get("container.class");
        if (prop == null) {
            this.secureContainerProps.put("container.class", GSI_CONTAINER_CLASS);
        } else {
            this.properties.remove("container.class");
            this.secureContainerProps.put("container.class", prop);
        }
        prop = (String)this.properties.get("org.globus.gsi.mode");
        if (prop == null) {
            this.properties.put("org.globus.gsi.mode", "gsi");
        }
        super.init(properties);
    }

    protected void setCallbackEndpoint(NotificationSinkCallback callback) {
        callback.setProperty("port", String.valueOf(this.secureContainer.getPort()));
        callback.setProperty("protocol", this.secureContainer.getURL().getProtocol());
    }

    public synchronized void startListening(boolean isMainThread) throws GridServiceException {
        if (this.secureContainer == null) {
            this.secureContainer = ServiceContainer.createContainer(this.secureContainerProps);
            super.startListening(isMainThread);
            String url = "http://" + this.serviceContainer.getHost() + ":" + this.serviceContainer.getPort() + "/";
            ContainerConfig.getConfig().setOption("schemaRoot", url);
        }
    }

    public synchronized void stopListening() throws GridServiceException {
        if (this.secureContainer != null) {
            this.secureContainer.stopServer();
            this.secureContainer = null;
        }
        super.stopListening();
    }
}

