/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client.managers;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.client.Service;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationSinkCallback;
import org.globus.ogsa.WSDLGenerator;
import org.globus.ogsa.client.managers.GSINotificationSinkManager;
import org.globus.ogsa.client.managers.SecureNotificationSinkManager;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.deployment.ServiceDeployment;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.server.ServiceContainer;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.SubscriptionHelper;
import org.globus.ogsa.wsdl.GSR;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.InfinityType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.NotificationSource;
import org.gridforum.ogsi.NotificationSubscription;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.holders.LocatorTypeHolder;
import org.gridforum.ogsi.holders.TerminationTimeTypeHolder;

public class NotificationSinkManager {
    public static final boolean MAIN_THREAD = true;
    public static final boolean CHILD_THREAD = false;
    private static final String[] secProperties = new String[]{"org.globus.gsi.mode", "org.globus.gsi.credentials", "org.globus.gsi.authorization", "org.globus.ogsa.security.authorization", "org.globus.security.msg.type", "org.globus.ogsa.security.sign.msg", "org.globus.ogsa.security.grim.policy.handler"};
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$client$managers$NotificationSinkManager == null ? (class$org$globus$ogsa$client$managers$NotificationSinkManager = NotificationSinkManager.class$("org.globus.ogsa.client.managers.NotificationSinkManager")) : class$org$globus$ogsa$client$managers$NotificationSinkManager).getName());
    private Service localService = null;
    private ServiceNode rootNode = ServiceNode.getRootNode();
    protected ServiceContainer serviceContainer = null;
    private boolean isListening = false;
    private ServiceDeployment deployment = null;
    private Hashtable sinkSubscriptionMap = new Hashtable();
    protected Map properties;
    static /* synthetic */ Class class$org$globus$ogsa$client$managers$NotificationSinkManager;

    protected NotificationSinkManager() {
        System.setProperty(ContainerConfig.SERVER_CONFIG_OPTION, "client-server-config.wsdd");
        if (this.rootNode.getNode("sinks") == null) {
            this.rootNode.bind("sinks", null);
        }
    }

    public static NotificationSinkManager getManager() {
        return NotificationSinkManager.getInstance(null);
    }

    public static NotificationSinkManager getInstance(String type) {
        if (type != null) {
            if (type.equalsIgnoreCase("GSI")) {
                return new GSINotificationSinkManager();
            }
            if (type.equalsIgnoreCase("Secure")) {
                return new SecureNotificationSinkManager();
            }
        }
        return new NotificationSinkManager();
    }

    public void init(Map properties) {
        this.properties = properties;
    }

    public void setService(Service service) {
        this.localService = service;
    }

    protected String getWsdl() {
        String schemaContext = null;
        try {
            ContainerConfig config = ContainerConfig.getConfig();
            schemaContext = config.getOption("schemaContext");
            if (schemaContext == null) {
                schemaContext = "/";
            }
        }
        catch (ConfigException ce) {
            logger.error((Object)MessageUtils.getMessage("OGSIC010"));
        }
        return schemaContext + "schema/ogsi/ogsi_notification_sink_service.wsdl";
    }

    protected void setCallbackEndpoint(NotificationSinkCallback callback) {
        callback.setProperty("protocol", this.serviceContainer.getURL().getProtocol());
        callback.setProperty("port", String.valueOf(this.serviceContainer.getPort()));
    }

    protected void setCallbackHandle(NotificationSinkCallback callback) {
        callback.setProperty("handleProtocol", this.serviceContainer.getURL().getProtocol());
        callback.setProperty("handlePort", String.valueOf(this.serviceContainer.getPort()));
    }

    public String addSink(NotificationSinkCallback callback) throws GridServiceException {
        return this.addSink(callback, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addSink(NotificationSinkCallback callback, Object id) throws GridServiceException {
        this.setCallbackEndpoint(callback);
        this.setCallbackHandle(callback);
        callback.setProperty("name", "Sink");
        String sinkID = NotificationSinkManager.getSinkID(this.serviceContainer.getURL(), callback, id);
        String sinkPath = "sinks/" + sinkID;
        WSDLGenerator.getWSDL(this.getWsdl(), sinkPath, callback);
        NotificationSinkManager notificationSinkManager = this;
        synchronized (notificationSinkManager) {
            if (this.deployment == null) {
                this.deployment = new ServiceDeployment(this.serviceContainer.getEngine());
            }
        }
        ServiceDesc desc = this.deployment.deploy(sinkPath, callback);
        if (this.localService != null) {
            desc.setTypeMappingRegistry((TypeMappingRegistry)this.localService.getTypeMappingRegistry());
        }
        String handle = (String)callback.getProperty("Handle");
        callback.setProperty("sinkID", sinkID);
        return handle;
    }

    public void removeSink(String sink) throws GridServiceException {
        URL sinkUrl = null;
        try {
            sinkUrl = new URL(sink);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        String path = sinkUrl.getPath();
        String sinkPath = path.substring(ContainerConfig.getOgsiLocation().length(), path.length());
        this.deployment.undeploy(sinkPath);
        logger.debug((Object)("Removing sink ID: " + sinkPath));
    }

    protected void setProperties(Stub stub) {
        if (this.properties == null) {
            return;
        }
        int i = 0;
        while (i < secProperties.length) {
            Object value = this.properties.get(secProperties[i]);
            if (value != null) {
                stub._setProperty(secProperties[i], value);
            }
            ++i;
        }
    }

    public static String getSinkID(URL url, NotificationSinkCallback callback, Object obj) {
        return System.currentTimeMillis() + "-" + url.getHost() + "-" + url.getPort() + "-" + callback.hashCode() + "-" + obj.hashCode();
    }

    public NotificationSubscription getSubscriptionService(String subscriptionID) throws FaultType, GridServiceException {
        if (subscriptionID == null) {
            throw new IllegalArgumentException("subscriptionID == null");
        }
        HandleType handle = (HandleType)this.sinkSubscriptionMap.get(subscriptionID);
        if (handle == null) {
            return null;
        }
        OGSIServiceGridLocator serviceLocator = new OGSIServiceGridLocator();
        return serviceLocator.getNotificationSubscriptionPort(handle);
    }

    public Calendar getDefaultSubscriptionTimeout() {
        Calendar timeout = Calendar.getInstance();
        timeout.add(10, 1);
        return timeout;
    }

    public String addListener(String serviceData, Calendar timeout, HandleType sourceHandle, NotificationSinkCallback callback) throws RemoteException, GridServiceException {
        return this.addListener(new QName("", serviceData), timeout, sourceHandle, callback);
    }

    public String addListener(QName serviceData, Calendar timeout, HandleType sourceHandle, NotificationSinkCallback callback) throws RemoteException, GridServiceException {
        return this.addListener(new QName[]{serviceData}, timeout, sourceHandle, callback);
    }

    public String addListener(QName[] serviceData, Calendar timeout, HandleType sourceHandle, NotificationSinkCallback callback) throws RemoteException, GridServiceException {
        return this.addListener(serviceData, timeout, sourceHandle, callback, SubscriptionHelper.getNameExpression(serviceData));
    }

    public String addListener(QName[] serviceData, Calendar timeout, HandleType sourceHandle, NotificationSinkCallback callback, ExtensibilityType subscriptionExpression) throws RemoteException, GridServiceException {
        String handleUrl = this.addSink(callback, serviceData);
        OGSIServiceGridLocator serviceLocator = new OGSIServiceGridLocator();
        NotificationSource source = serviceLocator.getNotificationSourcePort(sourceHandle);
        this.setProperties((Stub)source);
        String endpointUrl = (String)callback.getProperty("Endpoint");
        String subscriptionID = (String)callback.getProperty("sinkID");
        logger.debug((Object)("Adding sink handle: " + handleUrl + " endpoint: " + endpointUrl));
        LocatorTypeHolder locator = new LocatorTypeHolder();
        LocatorType sinkLocator = new LocatorType();
        sinkLocator.setHandle(new HandleType[]{new HandleType(handleUrl)});
        ExtendedDateTimeType expirationTime = new ExtendedDateTimeType();
        if (timeout == null) {
            timeout = this.getDefaultSubscriptionTimeout();
        }
        if (timeout == null) {
            expirationTime.setValue(InfinityType.infinity);
        } else {
            expirationTime.setValue(timeout);
        }
        TerminationTimeTypeHolder termination = new TerminationTimeTypeHolder();
        source.subscribe(subscriptionExpression, sinkLocator, expirationTime, locator, termination);
        logger.debug((Object)("got back subscription locator: " + locator.value));
        GSR gsr = GSR.newInstance(locator.value);
        this.sinkSubscriptionMap.put(subscriptionID, gsr.getHandle());
        return subscriptionID;
    }

    public void removeListener(String subscriptionID) throws RemoteException, GridServiceException {
        NotificationSubscription service = this.getSubscriptionService(subscriptionID);
        if (service != null) {
            this.setProperties((Stub)service);
            service.destroy();
            if (this.deployment != null) {
                this.deployment.undeploy("sinks/" + subscriptionID);
                logger.debug((Object)("Removing sink ID: sinks/" + subscriptionID));
            }
        }
    }

    public synchronized void unregisterListener(String subscriptionID) {
        if (subscriptionID == null) {
            throw new IllegalArgumentException("subscriptionID == null");
        }
        this.sinkSubscriptionMap.remove(subscriptionID);
    }

    public synchronized void startListening(boolean isMainThread) throws GridServiceException {
        if (!this.isListening) {
            this.isListening = true;
            this.serviceContainer = this.properties == null ? ServiceContainer.createContainer(isMainThread) : ServiceContainer.createContainer(this.properties);
        }
    }

    public void startListening() throws GridServiceException {
        this.startListening(false);
    }

    public synchronized void stopListening() throws GridServiceException {
        if (this.isListening) {
            this.serviceContainer.stopServer();
            this.isListening = false;
        }
    }

    public boolean isListening() {
        return this.isListening;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

