/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client.reflection;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class ReflectionSymbolTable
extends SymbolTable {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$client$reflection$ReflectionSymbolTable == null ? (class$org$globus$ogsa$client$reflection$ReflectionSymbolTable = ReflectionSymbolTable.class$("org.globus.ogsa.client.reflection.ReflectionSymbolTable")) : class$org$globus$ogsa$client$reflection$ReflectionSymbolTable).getName());
    HashMap operationParameters = new HashMap();
    HashMap operationReturnTypes = new HashMap();
    HashMap operationReturns = new HashMap();
    static /* synthetic */ Class class$org$globus$ogsa$client$reflection$ReflectionSymbolTable;

    public ReflectionSymbolTable() {
        super(new JavaGeneratorFactory().getBaseTypeMapping(), true, logger.isDebugEnabled(), false);
    }

    public void add(Document doc) throws Exception {
        this.populate(null, doc);
        this.populateOperationInfo();
    }

    private void populateOperationInfo() throws Exception {
        HashMap map = this.getHashMap();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                if (v.get(i) instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)v.get(i);
                    Binding binding = bEntry.getBinding();
                    PortType portType = binding.getPortType();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        String namespace = portType.getQName().getNamespaceURI();
                        Parameters params = this.getOperationParameters(operation, namespace, bEntry);
                        if (params.list != null) {
                            Vector<Parameter> parameterVector = new Vector<Parameter>();
                            Enumeration listEnum = params.list.elements();
                            while (listEnum.hasMoreElements()) {
                                Parameter parameter = (Parameter)listEnum.nextElement();
                                parameterVector.add(parameter);
                            }
                            this.operationParameters.put(operation.getName(), parameterVector);
                        }
                        if (params.returnParam == null) continue;
                        if (params.returnParam.getType() != null) {
                            this.operationReturnTypes.put(operation.getName(), params.returnParam.getType().getQName());
                        }
                        if (params.returnParam.getName() == null) continue;
                        this.operationReturns.put(operation.getName(), params.returnParam.getName());
                    }
                }
                ++i;
            }
        }
    }

    public void populateOperation(OperationDesc operation, String namespaceURI) {
        Vector parameters;
        QName returnTypeQName;
        logger.debug((Object)("Trying to populate operation: " + operation.getName()));
        if (operation.getReturnQName() == null) {
            logger.debug((Object)("Populating operation: " + operation.getName()));
            QName qname = new QName((String)this.operationReturns.get(operation.getName()));
            if (qname != null) {
                String namespace = qname.getNamespaceURI();
                if (namespace == null || namespace.equals("")) {
                    qname = new QName(namespaceURI, qname.getLocalPart());
                }
                operation.setReturnQName(qname);
                logger.debug((Object)("Setting QName return of operation: " + operation.getName() + " " + operation.getReturnQName()));
            }
        }
        if ((returnTypeQName = (QName)this.operationReturnTypes.get(operation.getName())) != null) {
            operation.setReturnType(new QName(returnTypeQName.getNamespaceURI(), returnTypeQName.getLocalPart()));
        }
        if ((parameters = (Vector)this.operationParameters.get(operation.getName())) != null) {
            Enumeration parameterEnum = parameters.elements();
            while (parameterEnum.hasMoreElements()) {
                Parameter parameter = (Parameter)parameterEnum.nextElement();
                ParameterDesc parameterDescription = new ParameterDesc();
                parameterDescription.setName(parameter.getName());
                QName parameterQName = parameter.getQName();
                parameterDescription.setQName(parameterQName);
                QName parameterTypeQName = parameter.getType().getQName();
                parameterDescription.setTypeQName(parameterTypeQName);
                operation.addParameter(parameterDescription);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

